/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.RoutePort;
import io.fabric8.openshift.api.model.RoutePortBuilder;
import io.fabric8.openshift.api.model.RoutePortFluentImpl;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import io.fabric8.openshift.api.model.RouteTargetReference;
import io.fabric8.openshift.api.model.RouteTargetReferenceBuilder;
import io.fabric8.openshift.api.model.RouteTargetReferenceFluentImpl;
import io.fabric8.openshift.api.model.TLSConfig;
import io.fabric8.openshift.api.model.TLSConfigBuilder;
import io.fabric8.openshift.api.model.TLSConfigFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class RouteSpecFluentImpl<A extends RouteSpecFluent<A>>
extends BaseFluent<A>
implements RouteSpecFluent<A> {
    private List<VisitableBuilder<? extends RouteTargetReference, ?>> alternateBackends = new ArrayList();
    private String host;
    private String path;
    private VisitableBuilder<? extends RoutePort, ?> port;
    private VisitableBuilder<? extends TLSConfig, ?> tls;
    private VisitableBuilder<? extends RouteTargetReference, ?> to;

    public RouteSpecFluentImpl() {
    }

    public RouteSpecFluentImpl(RouteSpec instance) {
        this.withAlternateBackends(instance.getAlternateBackends());
        this.withHost(instance.getHost());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
        this.withTls(instance.getTls());
        this.withTo(instance.getTo());
    }

    @Override
    public A addToAlternateBackends(RouteTargetReference ... items) {
        for (RouteTargetReference item : items) {
            RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
            this._visitables.add(builder);
            this.alternateBackends.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAlternateBackends(RouteTargetReference ... items) {
        for (RouteTargetReference item : items) {
            RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
            this._visitables.remove(builder);
            this.alternateBackends.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<RouteTargetReference> getAlternateBackends() {
        return RouteSpecFluentImpl.build(this.alternateBackends);
    }

    @Override
    public A withAlternateBackends(List<RouteTargetReference> alternateBackends) {
        this._visitables.removeAll(this.alternateBackends);
        this.alternateBackends.clear();
        if (alternateBackends != null) {
            for (RouteTargetReference item : alternateBackends) {
                this.addToAlternateBackends(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withAlternateBackends(RouteTargetReference ... alternateBackends) {
        this.alternateBackends.clear();
        if (alternateBackends != null) {
            for (RouteTargetReference item : alternateBackends) {
                this.addToAlternateBackends(item);
            }
        }
        return (A)this;
    }

    @Override
    public RouteSpecFluent.AlternateBackendsNested<A> addNewAlternateBackend() {
        return new AlternateBackendsNestedImpl();
    }

    @Override
    public RouteSpecFluent.AlternateBackendsNested<A> addNewAlternateBackendLike(RouteTargetReference item) {
        return new AlternateBackendsNestedImpl(item);
    }

    @Override
    public A addNewAlternateBackend(String kind, String name, Integer weight) {
        return this.addToAlternateBackends(new RouteTargetReference(kind, name, weight));
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public RoutePort getPort() {
        return this.port != null ? (RoutePort)this.port.build() : null;
    }

    @Override
    public A withPort(RoutePort port) {
        this._visitables.remove(this.port);
        if (port != null) {
            this.port = new RoutePortBuilder(port);
            this._visitables.add(this.port);
        }
        return (A)this;
    }

    @Override
    public RouteSpecFluent.PortNested<A> withNewPort() {
        return new PortNestedImpl();
    }

    @Override
    public RouteSpecFluent.PortNested<A> withNewPortLike(RoutePort item) {
        return new PortNestedImpl(item);
    }

    @Override
    public RouteSpecFluent.PortNested<A> editPort() {
        return this.withNewPortLike(this.getPort());
    }

    @Override
    public RouteSpecFluent.PortNested<A> editOrNewPort() {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : new RoutePortBuilder().build());
    }

    @Override
    public RouteSpecFluent.PortNested<A> editOrNewPortLike(RoutePort item) {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : item);
    }

    @Override
    public TLSConfig getTls() {
        return this.tls != null ? (TLSConfig)this.tls.build() : null;
    }

    @Override
    public A withTls(TLSConfig tls) {
        this._visitables.remove(this.tls);
        if (tls != null) {
            this.tls = new TLSConfigBuilder(tls);
            this._visitables.add(this.tls);
        }
        return (A)this;
    }

    @Override
    public RouteSpecFluent.TlsNested<A> withNewTls() {
        return new TlsNestedImpl();
    }

    @Override
    public RouteSpecFluent.TlsNested<A> withNewTlsLike(TLSConfig item) {
        return new TlsNestedImpl(item);
    }

    @Override
    public RouteSpecFluent.TlsNested<A> editTls() {
        return this.withNewTlsLike(this.getTls());
    }

    @Override
    public RouteSpecFluent.TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : new TLSConfigBuilder().build());
    }

    @Override
    public RouteSpecFluent.TlsNested<A> editOrNewTlsLike(TLSConfig item) {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : item);
    }

    @Override
    public RouteTargetReference getTo() {
        return this.to != null ? (RouteTargetReference)this.to.build() : null;
    }

    @Override
    public A withTo(RouteTargetReference to) {
        this._visitables.remove(this.to);
        if (to != null) {
            this.to = new RouteTargetReferenceBuilder(to);
            this._visitables.add(this.to);
        }
        return (A)this;
    }

    @Override
    public RouteSpecFluent.ToNested<A> withNewTo() {
        return new ToNestedImpl();
    }

    @Override
    public RouteSpecFluent.ToNested<A> withNewToLike(RouteTargetReference item) {
        return new ToNestedImpl(item);
    }

    @Override
    public RouteSpecFluent.ToNested<A> editTo() {
        return this.withNewToLike(this.getTo());
    }

    @Override
    public RouteSpecFluent.ToNested<A> editOrNewTo() {
        return this.withNewToLike(this.getTo() != null ? this.getTo() : new RouteTargetReferenceBuilder().build());
    }

    @Override
    public RouteSpecFluent.ToNested<A> editOrNewToLike(RouteTargetReference item) {
        return this.withNewToLike(this.getTo() != null ? this.getTo() : item);
    }

    @Override
    public A withNewTo(String kind, String name, Integer weight) {
        return this.withTo(new RouteTargetReference(kind, name, weight));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteSpecFluentImpl that = (RouteSpecFluentImpl)o;
        if (this.alternateBackends != null ? !this.alternateBackends.equals(that.alternateBackends) : that.alternateBackends != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.tls != null ? !this.tls.equals(that.tls) : that.tls != null) {
            return false;
        }
        return !(this.to != null ? !this.to.equals(that.to) : that.to != null);
    }

    public class ToNestedImpl<N>
    extends RouteTargetReferenceFluentImpl<RouteSpecFluent.ToNested<N>>
    implements RouteSpecFluent.ToNested<N>,
    Nested<N> {
        private final RouteTargetReferenceBuilder builder;

        ToNestedImpl(RouteTargetReference item) {
            this.builder = new RouteTargetReferenceBuilder(this, item);
        }

        ToNestedImpl() {
            this.builder = new RouteTargetReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteSpecFluentImpl.this.withTo(this.builder.build());
        }

        @Override
        public N endTo() {
            return this.and();
        }
    }

    public class TlsNestedImpl<N>
    extends TLSConfigFluentImpl<RouteSpecFluent.TlsNested<N>>
    implements RouteSpecFluent.TlsNested<N>,
    Nested<N> {
        private final TLSConfigBuilder builder;

        TlsNestedImpl(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        TlsNestedImpl() {
            this.builder = new TLSConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteSpecFluentImpl.this.withTls(this.builder.build());
        }

        @Override
        public N endTls() {
            return this.and();
        }
    }

    public class PortNestedImpl<N>
    extends RoutePortFluentImpl<RouteSpecFluent.PortNested<N>>
    implements RouteSpecFluent.PortNested<N>,
    Nested<N> {
        private final RoutePortBuilder builder;

        PortNestedImpl(RoutePort item) {
            this.builder = new RoutePortBuilder(this, item);
        }

        PortNestedImpl() {
            this.builder = new RoutePortBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteSpecFluentImpl.this.withPort(this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    public class AlternateBackendsNestedImpl<N>
    extends RouteTargetReferenceFluentImpl<RouteSpecFluent.AlternateBackendsNested<N>>
    implements RouteSpecFluent.AlternateBackendsNested<N>,
    Nested<N> {
        private final RouteTargetReferenceBuilder builder;

        AlternateBackendsNestedImpl(RouteTargetReference item) {
            this.builder = new RouteTargetReferenceBuilder(this, item);
        }

        AlternateBackendsNestedImpl() {
            this.builder = new RouteTargetReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteSpecFluentImpl.this.addToAlternateBackends(this.builder.build());
        }

        @Override
        public N endAlternateBackend() {
            return this.and();
        }
    }
}

