/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.server.rest.util;

import com.google.common.base.Preconditions;
import javax.servlet.ServletContext;
import org.apache.brooklyn.camp.CampPlatform;
import org.apache.brooklyn.camp.server.rest.CampServer;
import org.apache.brooklyn.camp.server.rest.util.DtoFactory;

public class CampRestContext {
    private final ServletContext servletContext;
    private CampPlatform platform;
    private DtoFactory dto;

    public CampRestContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public synchronized CampPlatform camp() {
        if (this.platform != null) {
            return this.platform;
        }
        this.platform = (CampPlatform)this.servletContext.getAttribute(CampServer.CAMP_PLATFORM_ATTRIBUTE);
        return (CampPlatform)Preconditions.checkNotNull((Object)this.platform, (Object)"CAMP platform instance not available from ServletContext");
    }

    public DtoFactory dto() {
        if (this.dto != null) {
            return this.dto;
        }
        this.dto = (DtoFactory)this.servletContext.getAttribute(CampServer.DTO_FACTORY);
        return (DtoFactory)Preconditions.checkNotNull((Object)this.dto, (Object)"CAMP DTO factory instance not available from ServletContext");
    }
}

