/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.cli;

import com.google.common.base.Objects;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import io.airlift.airline.ParseException;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.cli.AbstractMain;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.launcher.command.support.CloudExplorerSupport;

public class CloudExplorer {

    @Command(name="blob", description="list blob details for a given container and blob")
    public static class BlobstoreGetBlobCommand
    extends JcloudsCommand {
        @Option(name={"--container"}, description="name of the container of the blob")
        public String container;
        @Option(name={"--blob"}, description="name of the blob in the container")
        public String blob;

        @Override
        protected CloudExplorerSupport getExplorer(LocalManagementContext mgmt, boolean allLocations, String location, boolean autoconfirm) {
            this.failIfArguments();
            return new CloudExplorerSupport.GetBlob((ManagementContext)mgmt, allLocations, location, autoconfirm, this.container, this.blob);
        }

        @Override
        public Objects.ToStringHelper string() {
            return super.string().add("container", (Object)this.container).add("blob", (Object)this.blob);
        }
    }

    @Command(name="list-container", description="list container details for one or more container names")
    public static class BlobstoreListContainerCommand
    extends JcloudsCommand {
        @Override
        protected CloudExplorerSupport getExplorer(LocalManagementContext mgmt, boolean allLocations, String location, boolean autoconfirm) {
            if (this.arguments.isEmpty()) {
                throw new ParseException("Requires at least one container-name arguments", new Object[0]);
            }
            return new CloudExplorerSupport.BlobstoreListContainer((ManagementContext)mgmt, allLocations, location, autoconfirm, this.arguments);
        }

        @Override
        public Objects.ToStringHelper string() {
            return super.string().add("container-names", (Object)this.arguments);
        }
    }

    @Command(name="list-containers", description="list containers")
    public static class BlobstoreListContainersCommand
    extends JcloudsCommand {
        @Override
        protected CloudExplorerSupport getExplorer(LocalManagementContext mgmt, boolean allLocations, String location, boolean autoconfirm) {
            this.failIfArguments();
            return new CloudExplorerSupport.BlobstoreListContainers((ManagementContext)mgmt, allLocations, location, autoconfirm);
        }
    }

    @Command(name="terminate-instances", description="terminate instances for one or more instance IDs")
    public static class ComputeTerminateInstancesCommand
    extends JcloudsCommand {
        @Override
        protected CloudExplorerSupport getExplorer(LocalManagementContext mgmt, boolean allLocations, String location, boolean autoconfirm) {
            if (this.arguments.isEmpty()) {
                throw new ParseException("Requires at least one instance-id arguments", new Object[0]);
            }
            return new CloudExplorerSupport.TerminateInstances((ManagementContext)mgmt, allLocations, location, autoconfirm, this.arguments);
        }

        @Override
        public Objects.ToStringHelper string() {
            return super.string().add("instanceIds", (Object)this.arguments);
        }
    }

    @Command(name="default-template", description="compute default template")
    public static class ComputeDefaultTemplateCommand
    extends JcloudsCommand {
        @Override
        protected CloudExplorerSupport getExplorer(LocalManagementContext mgmt, boolean allLocations, String location, boolean autoconfirm) {
            this.failIfArguments();
            return new CloudExplorerSupport.ComputeDefaultTemplate((ManagementContext)mgmt, allLocations, location, autoconfirm);
        }
    }

    @Command(name="get-image", description="get image details for one or more imageIds")
    public static class ComputeGetImageCommand
    extends JcloudsCommand {
        @Override
        protected CloudExplorerSupport getExplorer(LocalManagementContext mgmt, boolean allLocations, String location, boolean autoconfirm) {
            if (this.arguments.isEmpty()) {
                throw new ParseException("Requires at least one image-id arguments", new Object[0]);
            }
            return new CloudExplorerSupport.GetImage((ManagementContext)mgmt, allLocations, location, autoconfirm, this.arguments);
        }

        @Override
        public Objects.ToStringHelper string() {
            return super.string().add("imageIds", (Object)this.arguments);
        }
    }

    @Command(name="list-hardware-profiles", description="list hardware profiles")
    public static class ComputeListHardwareProfilesCommand
    extends JcloudsCommand {
        @Override
        protected CloudExplorerSupport getExplorer(LocalManagementContext mgmt, boolean allLocations, String location, boolean autoconfirm) {
            this.failIfArguments();
            return new CloudExplorerSupport.ListHardwareProfiles((ManagementContext)mgmt, allLocations, location, autoconfirm);
        }
    }

    @Command(name="list-images", description="list images")
    public static class ComputeListImagesCommand
    extends JcloudsCommand {
        @Override
        protected CloudExplorerSupport getExplorer(LocalManagementContext mgmt, boolean allLocations, String location, boolean autoconfirm) {
            this.failIfArguments();
            return new CloudExplorerSupport.ListImages((ManagementContext)mgmt, allLocations, location, autoconfirm);
        }
    }

    @Command(name="list-instances", description="list instances")
    public static class ComputeListInstancesCommand
    extends JcloudsCommand {
        @Override
        protected CloudExplorerSupport getExplorer(LocalManagementContext mgmt, boolean allLocations, String location, boolean autoconfirm) {
            this.failIfArguments();
            return new CloudExplorerSupport.ListInstances((ManagementContext)mgmt, allLocations, location, autoconfirm);
        }
    }

    public static abstract class JcloudsCommand
    extends AbstractMain.BrooklynCommandCollectingArgs {
        @Option(name={"--all-locations"}, title="all locations", description="All locations (i.e. all locations in brooklyn.properties for which there are credentials)")
        public boolean allLocations;
        @Option(name={"-l", "--location"}, title="location spec", description="A location spec (e.g. referring to a named location in brooklyn.properties file)")
        public String location;
        @Option(name={"-y", "--yes"}, title="auto-confirm", description="Automatically answer yes to any questions")
        public boolean autoConfirm;

        protected abstract CloudExplorerSupport getExplorer(LocalManagementContext var1, boolean var2, String var3, boolean var4);

        @Override
        public Void call() throws Exception {
            LocalManagementContext mgmt = new LocalManagementContext();
            try {
                CloudExplorerSupport explorer = this.getExplorer(mgmt, this.allLocations, this.location, this.autoConfirm);
                explorer.call();
            }
            finally {
                mgmt.terminate();
            }
            return null;
        }

        @Override
        public Objects.ToStringHelper string() {
            return super.string().add("location", (Object)this.location);
        }
    }
}

