/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.suppliers;

import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.ec2.compute.domain.RegionAndName;

@Singleton
public class RegionAndNameToImageSupplier
implements Supplier<LoadingCache<RegionAndName, ? extends Image>> {
    private final LoadingCache<RegionAndName, Image> cache;

    @Inject
    protected RegionAndNameToImageSupplier(CacheLoader<RegionAndName, Image> regionAndIdToImage, @Named(value="jclouds.session-interval") long expirationSecs) {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(expirationSecs, TimeUnit.SECONDS).build(regionAndIdToImage);
    }

    public LoadingCache<RegionAndName, ? extends Image> get() {
        return this.cache;
    }
}

