/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.cloudstack.functions.ParseIdToNameFromHttpResponse;
import org.jclouds.http.HttpResponse;

@Singleton
public class ParseIdToNameEntryFromHttpResponse
implements Function<HttpResponse, Map.Entry<String, String>> {
    private final ParseIdToNameFromHttpResponse parser;

    @Inject
    public ParseIdToNameEntryFromHttpResponse(ParseIdToNameFromHttpResponse parser) {
        this.parser = (ParseIdToNameFromHttpResponse)Preconditions.checkNotNull((Object)parser, (Object)"parser");
    }

    public Map.Entry<String, String> apply(HttpResponse response) {
        Preconditions.checkNotNull((Object)response, (Object)"response");
        Map<String, String> toParse = this.parser.apply(response);
        Preconditions.checkNotNull(toParse, (String)"parsed result from %s", (Object[])new Object[]{response});
        return (Map.Entry)Iterables.getFirst(toParse.entrySet(), null);
    }
}

