/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.http.executor.apacheclient;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Map;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.http.HttpToolResponse;
import org.apache.brooklyn.util.http.executor.HttpConfig;
import org.apache.brooklyn.util.http.executor.HttpExecutor;
import org.apache.brooklyn.util.http.executor.HttpRequest;
import org.apache.brooklyn.util.http.executor.HttpResponse;
import org.apache.brooklyn.util.http.executor.apacheclient.HttpResponseWrapper;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;

@Beta
public class HttpExecutorImpl
implements HttpExecutor {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final HttpConfig DEFAULT_CONFIG = HttpConfig.builder().laxRedirect(false).trustAll(false).trustSelfSigned(false).build();

    public static HttpExecutorImpl newInstance() {
        return new HttpExecutorImpl();
    }

    public HttpExecutorImpl(Map<?, ?> props) {
    }

    public HttpExecutorImpl() {
    }

    @Override
    public HttpResponse execute(HttpRequest request) throws IOException {
        HttpToolResponse response;
        HttpConfig config = request.config() != null ? request.config() : DEFAULT_CONFIG;
        UsernamePasswordCredentials creds = request.credentials() != null ? new UsernamePasswordCredentials(request.credentials().getUser(), request.credentials().getPassword()) : null;
        HttpClient httpClient = HttpTool.httpClientBuilder().uri(request.uri()).credential((Optional<? extends Credentials>)Optional.fromNullable((Object)creds)).laxRedirect(config.laxRedirect()).trustSelfSigned(config.trustSelfSigned()).trustAll(config.trustAll()).build();
        switch (request.method().toUpperCase()) {
            case "GET": {
                response = HttpTool.httpGet(httpClient, request.uri(), request.headers());
                break;
            }
            case "HEAD": {
                response = HttpTool.httpHead(httpClient, request.uri(), request.headers());
                break;
            }
            case "POST": {
                response = HttpTool.httpPost(httpClient, request.uri(), request.headers(), this.orEmpty(request.body()));
                break;
            }
            case "PUT": {
                response = HttpTool.httpPut(httpClient, request.uri(), request.headers(), this.orEmpty(request.body()));
                break;
            }
            case "DELETE": {
                response = HttpTool.httpDelete(httpClient, request.uri(), request.headers());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported method '" + request.method() + "' for URI " + request.uri());
            }
        }
        return new HttpResponseWrapper(response);
    }

    protected byte[] orEmpty(byte[] val) {
        return val != null ? val : EMPTY_BYTE_ARRAY;
    }
}

