/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.balancer;

import com.twitter.util.Await;
import com.twitter.util.Awaitable;
import com.twitter.util.Function;
import com.twitter.util.Future;
import com.twitter.util.FutureEventListener;
import org.apache.distributedlog.client.monitor.MonitorServiceClient;
import org.apache.distributedlog.service.DistributedLogClient;
import org.apache.distributedlog.service.balancer.StreamMover;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;

public class StreamMoverImpl
implements StreamMover {
    private static final Logger logger = LoggerFactory.getLogger(StreamMoverImpl.class);
    final String source;
    final String target;
    final DistributedLogClient srcClient;
    final DistributedLogClient targetClient;
    final MonitorServiceClient srcMonitor;
    final MonitorServiceClient targetMonitor;

    public StreamMoverImpl(String source, DistributedLogClient srcClient, MonitorServiceClient srcMonitor, String target, DistributedLogClient targetClient, MonitorServiceClient targetMonitor) {
        this.source = source;
        this.srcClient = srcClient;
        this.srcMonitor = srcMonitor;
        this.target = target;
        this.targetClient = targetClient;
        this.targetMonitor = targetMonitor;
    }

    @Override
    public boolean moveStream(String streamName) {
        try {
            this.doMoveStream(streamName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void doMoveStream(final String streamName) throws Exception {
        Await.result((Awaitable)this.srcClient.release(streamName).flatMap((Function1)new Function<Void, Future<Void>>(){

            public Future<Void> apply(Void result) {
                return StreamMoverImpl.this.targetMonitor.check(streamName).addEventListener((FutureEventListener)new FutureEventListener<Void>(){

                    public void onSuccess(Void value) {
                        logger.info("Moved stream {} from {} to {}.", new Object[]{streamName, StreamMoverImpl.this.source, StreamMoverImpl.this.target});
                    }

                    public void onFailure(Throwable cause) {
                        logger.info("Failed to move stream {} from region {} to {} : ", new Object[]{streamName, StreamMoverImpl.this.source, StreamMoverImpl.this.target, cause});
                    }
                });
            }
        }));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StreamMover('").append(this.source).append("' -> '").append(this.target).append("')");
        return sb.toString();
    }
}

