/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.twitter.common.base.MorePreconditions;
import com.twitter.common.stats.SampledStat;
import com.twitter.common.stats.Stats;
import java.util.concurrent.LinkedBlockingDeque;

public class MovingWindowDelta<T extends Number>
extends SampledStat<Long> {
    private static final int DEFAULT_WINDOW_SIZE = 60;
    private final LinkedBlockingDeque<Long> deltaSeries;
    private final Supplier<T> inputAccessor;
    long sumDelta = 0L;
    long lastInput = 0L;

    private MovingWindowDelta(String name, Supplier<T> inputAccessor, int windowSize) {
        super(name, 0L);
        Preconditions.checkArgument((windowSize >= 1 ? 1 : 0) != 0);
        Preconditions.checkNotNull(inputAccessor);
        MorePreconditions.checkNotBlank((String)name);
        this.deltaSeries = new LinkedBlockingDeque(windowSize);
        this.inputAccessor = inputAccessor;
        Stats.export(this);
    }

    public static <T extends Number> MovingWindowDelta<T> of(String name, Supplier<T> inputAccessor, int windowSize) {
        return new MovingWindowDelta<T>(name, inputAccessor, windowSize);
    }

    public static <T extends Number> MovingWindowDelta<T> of(String name, Supplier<T> inputAccessor) {
        return MovingWindowDelta.of(name, inputAccessor, 60);
    }

    @Override
    public Long doSample() {
        long lastDelta = 0L;
        if (this.deltaSeries.remainingCapacity() == 0) {
            lastDelta = this.deltaSeries.removeFirst();
        }
        long newInput = ((Number)this.inputAccessor.get()).longValue();
        long newDelta = newInput - this.lastInput;
        this.lastInput = newInput;
        this.deltaSeries.addLast(newDelta);
        this.sumDelta += newDelta - lastDelta;
        return this.sumDelta;
    }
}

