/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.stream.limiter;

import java.io.Closeable;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.exceptions.OverCapacityException;
import org.apache.distributedlog.limiter.RequestLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamicRequestLimiter<Req>
implements RequestLimiter<Req>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicRequestLimiter.class);
    private final ConfigurationListener listener;
    private final Feature rateLimitDisabledFeature;
    volatile RequestLimiter<Req> limiter;
    final DynamicDistributedLogConfiguration dynConf;

    public DynamicRequestLimiter(DynamicDistributedLogConfiguration dynConf, StatsLogger statsLogger, Feature rateLimitDisabledFeature) {
        final StatsLogger limiterStatsLogger = statsLogger.scope("dynamic");
        this.dynConf = dynConf;
        this.rateLimitDisabledFeature = rateLimitDisabledFeature;
        this.listener = new ConfigurationListener(){

            public void configurationChanged(ConfigurationEvent event) {
                LOG.debug("Config changed callback invoked with event {} {} {} {}", new Object[]{event.getPropertyName(), event.getPropertyValue(), event.getType(), event.isBeforeUpdate()});
                if (!event.isBeforeUpdate()) {
                    limiterStatsLogger.getCounter("config_changed").inc();
                    LOG.debug("Rebuilding limiter");
                    DynamicRequestLimiter.this.limiter = DynamicRequestLimiter.this.build();
                }
            }
        };
        LOG.debug("Registering config changed callback");
        dynConf.addConfigurationListener(this.listener);
    }

    public void initialize() {
        this.limiter = this.build();
    }

    public void apply(Req request) throws OverCapacityException {
        if (this.rateLimitDisabledFeature.isAvailable()) {
            return;
        }
        this.limiter.apply(request);
    }

    @Override
    public void close() {
        boolean success = this.dynConf.removeConfigurationListener(this.listener);
        LOG.debug("Deregistering config changed callback success={}", (Object)success);
    }

    protected abstract RequestLimiter<Req> build();
}

