/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.jshell;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.openjdk.tools.jshell.JShell;
import org.openjdk.tools.jshell.Key;
import org.openjdk.tools.jshell.Snippet;

class KeyMap {
    private final JShell state;
    private final Map<String, Key.TypeDeclKey> classMap = new LinkedHashMap<String, Key.TypeDeclKey>();
    private final Map<String, Key.MethodKey> methodMap = new LinkedHashMap<String, Key.MethodKey>();
    private final Map<String, Key.VarKey> varMap = new LinkedHashMap<String, Key.VarKey>();
    private final Map<String, Key.ImportKey> importMap = new LinkedHashMap<String, Key.ImportKey>();

    KeyMap(JShell state) {
        this.state = state;
    }

    Key.TypeDeclKey keyForClass(String name) {
        return this.classMap.computeIfAbsent(name, k -> new Key.TypeDeclKey(this.state, name));
    }

    Key.MethodKey keyForMethod(String name, String parameterTypes) {
        return this.methodMap.computeIfAbsent(name + ":" + parameterTypes, k -> new Key.MethodKey(this.state, name, parameterTypes));
    }

    Key.VarKey keyForVariable(String name) {
        return this.varMap.computeIfAbsent(name, k -> new Key.VarKey(this.state, name));
    }

    Key.ImportKey keyForImport(String name, Snippet.SubKind snippetKind) {
        return this.importMap.computeIfAbsent(name + ":" + (snippetKind == Snippet.SubKind.SINGLE_TYPE_IMPORT_SUBKIND || snippetKind == Snippet.SubKind.SINGLE_STATIC_IMPORT_SUBKIND ? "single" : snippetKind.toString()), k -> new Key.ImportKey(this.state, name, snippetKind));
    }

    Key.StatementKey keyForStatement() {
        return new Key.StatementKey(this.state);
    }

    Key.ExpressionKey keyForExpression(String name, String type) {
        return new Key.ExpressionKey(this.state, name, type);
    }

    Key.ErroneousKey keyForErroneous() {
        return new Key.ErroneousKey(this.state);
    }

    boolean doesVariableNameExist(String name) {
        return this.varMap.get(name) != null;
    }

    Stream<Key.ImportKey> importKeys() {
        return this.importMap.values().stream();
    }
}

