/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.DoublePointable;

public class DoubleToInt32TypeConvertComputer
implements ITypeConvertComputer {
    private static final DoubleToInt32TypeConvertComputer INSTANCE_STRICT = new DoubleToInt32TypeConvertComputer(true);
    private static final DoubleToInt32TypeConvertComputer INSTANCE_LAX = new DoubleToInt32TypeConvertComputer(false);
    private final boolean strict;

    private DoubleToInt32TypeConvertComputer(boolean strict) {
        this.strict = strict;
    }

    public static DoubleToInt32TypeConvertComputer getInstance(boolean strict) {
        return strict ? INSTANCE_STRICT : INSTANCE_LAX;
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        int targetValue = this.convertType(data, start);
        out.writeByte(ATypeTag.INTEGER.serialize());
        out.writeInt(targetValue);
    }

    int convertType(byte[] data, int start) throws HyracksDataException {
        double sourceValue = DoublePointable.getDouble((byte[])data, (int)start);
        return this.convert(sourceValue);
    }

    @Override
    public IAObject convertType(IAObject sourceObject, ATypeHierarchy.TypeCastingMathFunctionType mathFunction) throws HyracksDataException {
        double sourceValue = ATypeHierarchy.applyMathFunctionToDoubleValue(sourceObject, mathFunction);
        int targetValue = this.convert(sourceValue);
        return new AInt32(targetValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int convert(double sourceValue) throws HyracksDataException {
        if (Double.isNaN(sourceValue)) {
            if (!this.strict) return 0;
            this.raiseBoundaryCheckException(sourceValue);
            return (int)Math.floor(sourceValue);
        } else {
            if (sourceValue > 2.147483647E9) {
                if (!this.strict) return Integer.MAX_VALUE;
                return this.raiseBoundaryCheckException(sourceValue);
            }
            if (!(sourceValue < -2.147483648E9)) return (int)Math.floor(sourceValue);
            if (!this.strict) return Integer.MIN_VALUE;
            return this.raiseBoundaryCheckException(sourceValue);
        }
    }

    private int raiseBoundaryCheckException(double sourceValue) throws HyracksDataException {
        throw new RuntimeDataException(ErrorCode.TYPE_CONVERT_OUT_OF_BOUND, new Serializable[]{Double.valueOf(sourceValue), ATypeTag.INTEGER, Integer.valueOf(Integer.MAX_VALUE), Integer.valueOf(Integer.MIN_VALUE)});
    }
}

