/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.buffercache;

import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IFileHandle;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.hyracks.storage.common.buffercache.BufferCache;
import org.apache.hyracks.storage.common.buffercache.BufferCacheHeaderHelper;
import org.apache.hyracks.storage.common.buffercache.CachedPage;
import org.apache.hyracks.storage.common.buffercache.IPageReplacementStrategy;
import org.apache.hyracks.storage.common.compression.file.CompressedFileReference;
import org.apache.hyracks.storage.common.compression.file.ICompressedPageWriter;

public abstract class AbstractBufferedFileIOManager {
    private static final String ERROR_MESSAGE = "%s unexpected number of bytes: [expected: %d, actual: %d, file: %s]";
    private static final String READ = "Read";
    private static final String WRITE = "Written";
    protected final BufferCache bufferCache;
    protected final IPageReplacementStrategy pageReplacementStrategy;
    private final BlockingQueue<BufferCacheHeaderHelper> headerPageCache;
    private final IOManager ioManager;
    private IFileHandle fileHandle;
    private volatile boolean hasOpen;

    protected AbstractBufferedFileIOManager(BufferCache bufferCache, IIOManager ioManager, BlockingQueue<BufferCacheHeaderHelper> headerPageCache, IPageReplacementStrategy pageReplacementStrategy) {
        this.bufferCache = bufferCache;
        this.ioManager = (IOManager)ioManager;
        this.headerPageCache = headerPageCache;
        this.pageReplacementStrategy = pageReplacementStrategy;
        this.hasOpen = false;
    }

    public abstract void read(CachedPage var1) throws HyracksDataException;

    public void write(CachedPage cPage) throws HyracksDataException {
        int totalPages = cPage.getFrameSizeMultiplier();
        int extraBlockPageId = cPage.getExtraBlockPageId();
        BufferCacheHeaderHelper header = this.checkoutHeaderHelper();
        this.write(cPage, header, totalPages, extraBlockPageId);
    }

    protected abstract void write(CachedPage var1, BufferCacheHeaderHelper var2, int var3, int var4) throws HyracksDataException;

    public void open(FileReference fileRef) throws HyracksDataException {
        this.fileHandle = this.ioManager.open(fileRef, IIOManager.FileReadWriteMode.READ_WRITE, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
        this.hasOpen = true;
    }

    public void close() throws HyracksDataException {
        if (this.hasOpen) {
            this.ioManager.close(this.fileHandle);
        }
    }

    public void purge() throws HyracksDataException {
        this.ioManager.close(this.fileHandle);
    }

    public void force(boolean metadata) throws HyracksDataException {
        this.ioManager.sync(this.fileHandle, metadata);
    }

    public abstract int getNumberOfPages() throws HyracksDataException;

    public void markAsDeleted() throws HyracksDataException {
        this.fileHandle = null;
    }

    public boolean hasBeenDeleted() {
        return this.fileHandle == null;
    }

    public final boolean hasBeenOpened() {
        return this.hasOpen;
    }

    public final FileReference getFileReference() {
        return this.fileHandle.getFileReference();
    }

    public static void createFile(BufferCache bufferCache, FileReference fileRef) throws HyracksDataException {
        IoUtil.create((FileReference)fileRef);
        if (fileRef.isCompressed()) {
            CompressedFileReference cFileRef = (CompressedFileReference)fileRef;
            try {
                bufferCache.createFile(cFileRef.getLAFFileReference());
            }
            catch (HyracksDataException e) {
                IoUtil.delete((FileReference)fileRef);
                throw e;
            }
        }
    }

    public static void deleteFile(FileReference fileRef) throws HyracksDataException {
        HyracksDataException savedEx = null;
        try {
            CompressedFileReference cFileRef;
            FileReference lafFileRef;
            if (fileRef.isCompressed() && (lafFileRef = (cFileRef = (CompressedFileReference)fileRef).getLAFFileReference()).getFile().exists()) {
                IoUtil.delete((FileReference)lafFileRef);
            }
        }
        catch (HyracksDataException e) {
            savedEx = e;
        }
        try {
            IoUtil.delete((FileReference)fileRef);
        }
        catch (HyracksDataException e) {
            if (savedEx != null) {
                savedEx.addSuppressed((Throwable)e);
            }
            savedEx = e;
        }
        if (savedEx != null) {
            throw savedEx;
        }
    }

    public abstract ICompressedPageWriter getCompressedPageWriter();

    protected abstract long getFirstPageOffset(CachedPage var1);

    protected abstract long getExtraPageOffset(CachedPage var1);

    protected final BufferCacheHeaderHelper checkoutHeaderHelper() {
        BufferCacheHeaderHelper helper = (BufferCacheHeaderHelper)this.headerPageCache.poll();
        if (helper == null) {
            helper = new BufferCacheHeaderHelper(this.bufferCache.getPageSize());
        }
        return helper;
    }

    protected final void returnHeaderHelper(BufferCacheHeaderHelper buffer) {
        this.headerPageCache.offer(buffer);
    }

    protected final long readToBuffer(ByteBuffer buf, long offset) throws HyracksDataException {
        return this.ioManager.syncRead(this.fileHandle, offset, buf);
    }

    protected final long writeToFile(ByteBuffer buf, long offset) throws HyracksDataException {
        return this.ioManager.doSyncWrite(this.fileHandle, offset, buf);
    }

    protected final long writeToFile(ByteBuffer[] buf, long offset) throws HyracksDataException {
        return this.ioManager.doSyncWrite(this.fileHandle, offset, buf);
    }

    protected final long getFileSize() {
        return this.ioManager.getSize(this.fileHandle);
    }

    protected final void verifyBytesWritten(long expected, long actual) {
        if (expected != actual) {
            this.throwException(WRITE, expected, actual);
        }
    }

    protected final boolean verifyBytesRead(long expected, long actual) {
        if (expected != actual) {
            if (actual == -1L) {
                return false;
            }
            this.throwException(READ, expected, actual);
        }
        return true;
    }

    protected void throwException(String op, long expected, long actual) {
        String path = this.fileHandle.getFileReference().getAbsolutePath();
        throw new IllegalStateException(String.format(ERROR_MESSAGE, op, expected, actual, path));
    }
}

