/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.List;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPreclusteredGroupByPOperator;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import org.apache.hyracks.algebricks.runtime.operators.aggreg.NestedPlansAccumulatingAggregatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.aggreg.NestedPlansRunningAggregatorFactory;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.preclustered.PreclusteredGroupOperatorDescriptor;

public class PreclusteredGroupByPOperator
extends AbstractPreclusteredGroupByPOperator {
    private final boolean groupAll;

    public PreclusteredGroupByPOperator(List<LogicalVariable> columnList, boolean groupAll) {
        super(columnList);
        this.groupAll = groupAll;
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.PRE_CLUSTERED_GROUP_BY;
    }

    @Override
    public boolean isMicroOperator() {
        return false;
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema opSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        GroupByOperator gby = (GroupByOperator)op;
        this.checkGroupAll(gby);
        int[] keys = JobGenHelper.variablesToFieldIndexes(this.columnList, inputSchemas[0]);
        int[] fdColumns = this.getFdColumns(gby, inputSchemas[0]);
        AlgebricksPipeline[] subplans = this.compileSubplans(inputSchemas[0], gby, opSchema, context);
        List<ILogicalPlan> nestedPlans = gby.getNestedPlans();
        Object aggregatorFactory = !nestedPlans.isEmpty() && ((ILogicalOperator)nestedPlans.get(0).getRoots().get(0).getValue()).getOperatorTag() == LogicalOperatorTag.RUNNINGAGGREGATE ? new NestedPlansRunningAggregatorFactory(subplans, keys, fdColumns) : new NestedPlansAccumulatingAggregatorFactory(subplans, keys, fdColumns);
        aggregatorFactory.setSourceLocation(gby.getSourceLocation());
        JobSpecification spec = builder.getJobSpec();
        IBinaryComparatorFactory[] comparatorFactories = JobGenHelper.variablesToAscBinaryComparatorFactories(this.columnList, context.getTypeEnvironment(op), context);
        RecordDescriptor recordDescriptor = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment(op), opSchema, context);
        int framesLimit = this.localMemoryRequirements.getMemoryBudgetInFrames();
        PreclusteredGroupOperatorDescriptor opDesc = new PreclusteredGroupOperatorDescriptor((IOperatorDescriptorRegistry)spec, keys, comparatorFactories, (IAggregatorDescriptorFactory)aggregatorFactory, recordDescriptor, this.groupAll, framesLimit);
        opDesc.setSourceLocation(gby.getSourceLocation());
        this.contributeOpDesc(builder, gby, (IOperatorDescriptor)opDesc);
        ILogicalOperator src = (ILogicalOperator)op.getInputs().get(0).getValue();
        builder.contributeGraphEdge(src, 0, op, 0);
    }

    @Override
    public String toString() {
        return this.getOperatorTag().toString() + (this.groupAll ? "(ALL)" : "") + this.columnList;
    }
}

