/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.util;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooPropUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ZooPropUtils.class);

    private ZooPropUtils() {
    }

    public static Map<String, InstanceId> readInstancesFromZk(ZooReader zooReader) {
        String instanceRoot = "/accumulo/instances";
        TreeMap<String, InstanceId> idMap = new TreeMap<String, InstanceId>();
        try {
            List names = zooReader.getChildren(instanceRoot);
            names.forEach(name -> {
                InstanceId iid = ZooPropUtils.getInstanceIdForName(zooReader, name);
                idMap.put((String)name, iid);
            });
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted reading instance name info from ZooKeeper", ex);
        }
        catch (KeeperException ex) {
            throw new IllegalStateException("Failed to read instance name info from ZooKeeper", ex);
        }
        return idMap;
    }

    private static InstanceId getInstanceIdForName(ZooReader zooReader, String name) {
        String instanceRoot = "/accumulo/instances";
        Object path = "";
        try {
            path = instanceRoot + "/" + name;
            byte[] uuid = zooReader.getData((String)path);
            return InstanceId.of((UUID)UUID.fromString(new String(uuid, StandardCharsets.UTF_8)));
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted reading instance id from ZooKeeper", ex);
        }
        catch (KeeperException ex) {
            LOG.warn("Failed to read instance id for " + (String)path);
            return null;
        }
    }

    public static Map<NamespaceId, String> getNamespaceIdToNameMap(InstanceId iid, ZooReader zooReader) {
        TreeMap<NamespaceId, String> namespaceToName = new TreeMap<NamespaceId, String>();
        String zooNsRoot = ZooUtil.getRoot((InstanceId)iid) + "/namespaces";
        try {
            List nsids = zooReader.getChildren(zooNsRoot);
            for (String id : nsids) {
                String path = zooNsRoot + "/" + id + "/name";
                String name = new String(zooReader.getData(path), StandardCharsets.UTF_8);
                namespaceToName.put(NamespaceId.of((String)id), name);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted reading namespace ids from ZooKeeper", ex);
        }
        catch (KeeperException ex) {
            throw new IllegalStateException("Failed to read namespace ids from ZooKeeper", ex);
        }
        return namespaceToName;
    }

    public static Map<TableId, String> getTableIdToName(InstanceId iid, Map<NamespaceId, String> id2NamespaceMap, ZooReader zooReader) {
        TreeMap<TableId, String> idToName = new TreeMap<TableId, String>();
        String zooTables = ZooUtil.getRoot((InstanceId)iid) + "/tables";
        try {
            List tids = zooReader.getChildren(zooTables);
            for (String t : tids) {
                String path = zooTables + "/" + t;
                String tname = new String(zooReader.getData(path + "/name"), StandardCharsets.UTF_8);
                NamespaceId tNsId = NamespaceId.of((String)new String(zooReader.getData(path + "/namespace"), StandardCharsets.UTF_8));
                if (tNsId.equals((Object)Namespace.DEFAULT.id())) {
                    idToName.put(TableId.of((String)t), tname);
                    continue;
                }
                idToName.put(TableId.of((String)t), id2NamespaceMap.get(tNsId) + "." + tname);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted reading table ids from ZooKeeper", ex);
        }
        catch (KeeperException ex) {
            throw new IllegalStateException("Failed reading table id info from ZooKeeper");
        }
        return idToName;
    }
}

