/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.memory.XxHash;
import org.apache.datasketches.thetacommon.ThetaUtil;
import org.apache.datasketches.tuple.Summary;

public final class Util {
    private static final int PRIME = 2050804337;

    public static final long[] doubleToLongArray(double value) {
        double d = value == 0.0 ? 0.0 : value;
        long[] array = new long[]{Double.doubleToLongBits(d)};
        return array;
    }

    public static final byte[] stringToByteArray(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value.getBytes(StandardCharsets.UTF_8);
    }

    public static short computeSeedHash(long seed) {
        long[] seedArr = new long[]{seed};
        short seedHash = (short)(MurmurHash3.hash(seedArr, 0L)[0] & 0xFFFFL);
        if (seedHash == 0) {
            throw new SketchesArgumentException("The given seed: " + seed + " produced a seedHash of zero. You must choose a different seed.");
        }
        return seedHash;
    }

    public static final void checkSeedHashes(short seedHashA, short seedHashB) {
        if (seedHashA != seedHashB) {
            throw new SketchesArgumentException("Incompatible Seed Hashes. " + seedHashA + ", " + seedHashB);
        }
    }

    public static int getStartingCapacity(int nomEntries, int lgResizeFactor) {
        return 1 << ThetaUtil.startingSubMultiple(Integer.numberOfTrailingZeros(org.apache.datasketches.common.Util.ceilingIntPowerOf2(nomEntries) * 2), lgResizeFactor, 5);
    }

    public static String stringConcat(String[] strArr) {
        int len = strArr.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(strArr[i]);
            if (i + 1 >= len) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static long stringHash(String s) {
        return XxHash.hashString((String)s, (long)0L, (long)s.length(), (long)2050804337L);
    }

    public static long stringArrHash(String[] strArray) {
        String s = Util.stringConcat(strArray);
        return XxHash.hashCharArr((char[])s.toCharArray(), (long)0L, (long)s.length(), (long)2050804337L);
    }

    public static <S extends Summary> S[] copySummaryArray(S[] summaryArr) {
        int len = summaryArr.length;
        Summary[] tmpSummaryArr = Util.newSummaryArray(summaryArr, (int)len);
        for (int i = 0; i < len; ++i) {
            S summary = summaryArr[i];
            if (summary == null) continue;
            tmpSummaryArr[i] = summary.copy();
        }
        return tmpSummaryArr;
    }

    public static <S extends Summary> S[] newSummaryArray(S[] summaryArr, int length) {
        Class<?> summaryType = summaryArr.getClass().getComponentType();
        Summary[] tmpSummaryArr = (Summary[])Array.newInstance(summaryType, length);
        return tmpSummaryArr;
    }
}

