/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.compactions;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.spi.compaction.CompactionExecutorId;
import org.apache.accumulo.core.spi.compaction.CompactionJob;
import org.apache.accumulo.core.spi.compaction.CompactionServiceId;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionQueueSummary;
import org.apache.accumulo.core.util.compaction.CompactionExecutorIdImpl;
import org.apache.accumulo.tserver.compactions.Compactable;
import org.apache.accumulo.tserver.compactions.CompactionExecutor;
import org.apache.accumulo.tserver.compactions.ExternalCompactionJob;
import org.apache.accumulo.tserver.compactions.SubmittedJob;

public class ExternalCompactionExecutor
implements CompactionExecutor {
    private final Set<ExternalJob> queuedJob = Collections.synchronizedSet(new HashSet());
    private final PriorityBlockingQueue<ExternalJob> queue;
    private final CompactionExecutorId ceid;

    public ExternalCompactionExecutor(CompactionExecutorId ceid) {
        this.ceid = ceid;
        Comparator<ExternalJob> priorityComparator = Comparator.comparingLong(ej -> ej.getJob().getPriority());
        priorityComparator = priorityComparator.reversed().thenComparingLong(ExternalJob::getTimeCreated);
        this.queue = new PriorityBlockingQueue<ExternalJob>(100, priorityComparator.thenComparing(priorityComparator));
    }

    @Override
    public SubmittedJob submit(CompactionServiceId csid, CompactionJob job, Compactable compactable, Consumer<Compactable> completionCallback) {
        Preconditions.checkArgument((!compactable.getExtent().isMeta() ? 1 : 0) != 0);
        ExternalJob extJob = new ExternalJob(job, compactable, csid);
        this.queue.add(extJob);
        return extJob;
    }

    @Override
    public int getCompactionsRunning(CompactionExecutor.CType ctype) {
        if (ctype == CompactionExecutor.CType.EXTERNAL) {
            throw new UnsupportedOperationException();
        }
        return 0;
    }

    @Override
    public int getCompactionsQueued(CompactionExecutor.CType ctype) {
        if (ctype != CompactionExecutor.CType.EXTERNAL) {
            return 0;
        }
        return this.queuedJob.size();
    }

    @Override
    public void stop() {
    }

    ExternalCompactionJob reserveExternalCompaction(long priority, String compactorId, ExternalCompactionId externalCompactionId) {
        ExternalCompactionJob found = null;
        while (found == null) {
            ExternalJob extJob = this.queue.poll();
            while (extJob != null && extJob.getStatus() != SubmittedJob.Status.QUEUED) {
                extJob = this.queue.poll();
            }
            if (extJob == null) break;
            if ((long)extJob.getJob().getPriority() >= priority) {
                if (!extJob.status.compareAndSet(SubmittedJob.Status.QUEUED, SubmittedJob.Status.RUNNING)) continue;
                this.queuedJob.remove(extJob);
                ExternalCompactionJob ecj = extJob.compactable.reserveExternalCompaction(extJob.csid, extJob.getJob(), compactorId, externalCompactionId);
                if (ecj == null) break;
                extJob.ecid = ecj.getExternalCompactionId();
                found = ecj;
                continue;
            }
            this.queue.add(extJob);
            break;
        }
        return found;
    }

    public Stream<TCompactionQueueSummary> summarize() {
        HashSet uniqPrios = new HashSet();
        this.queuedJob.forEach(job -> uniqPrios.add(job.getJob().getPriority()));
        Stream prioStream = uniqPrios.stream();
        if (uniqPrios.size() > 100) {
            prioStream = prioStream.sorted(Comparator.reverseOrder()).limit(100L);
        }
        String queueName = ((CompactionExecutorIdImpl)this.ceid).getExternalName();
        return prioStream.map(prio -> new TCompactionQueueSummary(queueName, prio.shortValue()));
    }

    public CompactionExecutorId getId() {
        return this.ceid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compactableClosed(KeyExtent extent) {
        List<ExternalJob> jobToCancel;
        Set<ExternalJob> set = this.queuedJob;
        synchronized (set) {
            jobToCancel = this.queuedJob.stream().filter(ejob -> ejob.getExtent().equals((Object)extent)).collect(Collectors.toList());
        }
        jobToCancel.forEach(job -> job.cancel(SubmittedJob.Status.QUEUED));
    }

    private class ExternalJob
    extends SubmittedJob {
        private final AtomicReference<SubmittedJob.Status> status;
        private final Compactable compactable;
        private final CompactionServiceId csid;
        private volatile ExternalCompactionId ecid;
        private final AtomicLong cancelCount;
        private final long timeCreated;

        ExternalJob(CompactionJob job, Compactable compactable, CompactionServiceId csid) {
            super(job);
            this.status = new AtomicReference<SubmittedJob.Status>(SubmittedJob.Status.QUEUED);
            this.cancelCount = new AtomicLong();
            this.compactable = compactable;
            this.csid = csid;
            ExternalCompactionExecutor.this.queuedJob.add(this);
            this.timeCreated = System.currentTimeMillis();
        }

        @Override
        public SubmittedJob.Status getStatus() {
            SubmittedJob.Status s = this.status.get();
            if (s == SubmittedJob.Status.RUNNING && this.ecid != null && !this.compactable.isActive(this.ecid)) {
                s = SubmittedJob.Status.COMPLETE;
            }
            return s;
        }

        @Override
        public boolean cancel(SubmittedJob.Status expectedStatus) {
            boolean canceled = false;
            if (expectedStatus == SubmittedJob.Status.QUEUED) {
                canceled = this.status.compareAndSet(expectedStatus, SubmittedJob.Status.CANCELED);
                if (canceled) {
                    ExternalCompactionExecutor.this.queuedJob.remove(this);
                }
                if (canceled && this.cancelCount.incrementAndGet() % 1024L == 0L) {
                    ExternalCompactionExecutor.this.queue.removeIf(ej -> ej.getStatus() == SubmittedJob.Status.CANCELED);
                }
            }
            return canceled;
        }

        public KeyExtent getExtent() {
            return this.compactable.getExtent();
        }

        public long getTimeCreated() {
            return this.timeCreated;
        }
    }
}

