/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.manager.thrift.TabletLoadState;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletLocationState;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.tablet.thrift.TUnloadTabletGoal;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.manager.state.DistributedStoreException;
import org.apache.accumulo.server.manager.state.TabletStateStore;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.managermessage.TabletStatusMessage;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnloadTabletHandler
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(UnloadTabletHandler.class);
    private final KeyExtent extent;
    private final TUnloadTabletGoal goalState;
    private final long requestTimeSkew;
    private final TabletServer server;

    public UnloadTabletHandler(TabletServer server, KeyExtent extent, TUnloadTabletGoal goalState, long requestTime) {
        this.extent = extent;
        this.goalState = goalState;
        this.server = server;
        this.requestTimeSkew = requestTime - TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Tablet t = null;
        log.info("Tablet unload for extent {} requested.", (Object)this.extent);
        Object object = this.server.unopenedTablets;
        synchronized (object) {
            if (this.server.unopenedTablets.contains(this.extent)) {
                this.server.unopenedTablets.remove(this.extent);
                return;
            }
        }
        object = this.server.openingTablets;
        synchronized (object) {
            while (this.server.openingTablets.contains(this.extent)) {
                try {
                    log.info("Waiting for tablet {} to finish opening before unloading.", (Object)this.extent);
                    this.server.openingTablets.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        object = this.server.onlineTablets;
        synchronized (object) {
            if (this.server.onlineTablets.snapshot().containsKey(this.extent)) {
                t = (Tablet)this.server.onlineTablets.snapshot().get(this.extent);
            }
        }
        if (t == null) {
            if (!this.server.recentlyUnloadedCache.containsKey(this.extent)) {
                log.info("told to unload tablet that was not being served {}", (Object)this.extent);
                this.server.enqueueManagerMessage(new TabletStatusMessage(TabletLoadState.UNLOAD_FAILURE_NOT_SERVING, this.extent));
            }
            return;
        }
        try {
            t.close(!this.goalState.equals((Object)TUnloadTabletGoal.DELETED));
        }
        catch (Exception e) {
            if ((t.isClosing() || t.isClosed()) && e instanceof IllegalStateException) {
                log.debug("Failed to unload tablet {}... it was already closing or closed : {}", (Object)this.extent, (Object)e.getMessage());
            } else {
                log.error("Failed to close tablet {}... Aborting migration", (Object)this.extent, (Object)e);
                this.server.enqueueManagerMessage(new TabletStatusMessage(TabletLoadState.UNLOAD_ERROR, this.extent));
            }
            return;
        }
        this.server.recentlyUnloadedCache.put(this.extent, System.currentTimeMillis());
        this.server.onlineTablets.remove(this.extent);
        try {
            TServerInstance instance = this.server.getTabletSession();
            TabletLocationState tls = null;
            try {
                tls = new TabletLocationState(this.extent, null, TabletMetadata.Location.current((TServerInstance)instance), null, null, null, false);
            }
            catch (TabletLocationState.BadLocationStateException e) {
                log.error("Unexpected error", (Throwable)e);
            }
            if (!this.goalState.equals((Object)TUnloadTabletGoal.SUSPENDED) || this.extent.isRootTablet() || this.extent.isMeta() && !this.server.getConfiguration().getBoolean(Property.MANAGER_METADATA_SUSPENDABLE)) {
                TabletStateStore.unassign((ServerContext)this.server.getContext(), (TabletLocationState)tls, null);
            } else {
                TabletStateStore.suspend((ServerContext)this.server.getContext(), (TabletLocationState)tls, null, (long)(this.requestTimeSkew + TimeUnit.NANOSECONDS.toMillis(System.nanoTime())));
            }
        }
        catch (DistributedStoreException ex) {
            log.warn("Unable to update storage", (Throwable)ex);
        }
        this.server.enqueueManagerMessage(new TabletStatusMessage(TabletLoadState.UNLOADED, this.extent));
        this.server.statsKeeper.saveMajorMinorTimes(t.getTabletStats());
    }
}

