/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.gc;

import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.gc.ReferenceFile;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;

public class ReferenceDirectory
extends ReferenceFile {
    private final String tabletDir;

    public ReferenceDirectory(TableId tableId, String dirName) {
        super(tableId, dirName);
        MetadataSchema.TabletsSection.ServerColumnFamily.validateDirCol(dirName);
        this.tabletDir = dirName;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    public String getTabletDir() {
        return this.tabletDir;
    }

    @Override
    public String getMetadataEntry() {
        if (!this.tabletDir.equals(this.metadataEntry)) {
            throw new IllegalStateException("Tablet dir " + this.tabletDir + " is not equal to metadataEntry: " + this.metadataEntry);
        }
        return this.metadataEntry;
    }
}

