/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TimedOutException;
import org.apache.accumulo.core.clientImpl.AccumuloServerException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ScanServerAttemptImpl;
import org.apache.accumulo.core.clientImpl.ScanServerAttemptReporter;
import org.apache.accumulo.core.clientImpl.ScanServerAttemptsImpl;
import org.apache.accumulo.core.clientImpl.ScannerOptions;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.clientImpl.TabletType;
import org.apache.accumulo.core.clientImpl.ThriftScanner;
import org.apache.accumulo.core.clientImpl.TimeoutTabletLocator;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.TabletIdImpl;
import org.apache.accumulo.core.dataImpl.thrift.InitialMultiScan;
import org.apache.accumulo.core.dataImpl.thrift.MultiScanResult;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TKeyValue;
import org.apache.accumulo.core.dataImpl.thrift.TRange;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.spi.scan.ScanServerAttempt;
import org.apache.accumulo.core.spi.scan.ScanServerSelections;
import org.apache.accumulo.core.spi.scan.ScanServerSelector;
import org.apache.accumulo.core.tabletscan.thrift.ScanServerBusyException;
import org.apache.accumulo.core.tabletscan.thrift.TSampleNotPresentException;
import org.apache.accumulo.core.tabletscan.thrift.TabletScanClientService;
import org.apache.accumulo.core.tabletserver.thrift.NoSuchScanIDException;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.accumulo.core.util.Retry;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletServerBatchReaderIterator
implements Iterator<Map.Entry<Key, Value>> {
    private static final Logger log = LoggerFactory.getLogger(TabletServerBatchReaderIterator.class);
    private final ClientContext context;
    private final TableId tableId;
    private final String tableName;
    private Authorizations authorizations = Authorizations.EMPTY;
    private final int numThreads;
    private final ExecutorService queryThreadPool;
    private final ScannerOptions options;
    private ArrayBlockingQueue<List<Map.Entry<Key, Value>>> resultsQueue;
    private Iterator<Map.Entry<Key, Value>> batchIterator;
    private List<Map.Entry<Key, Value>> batch;
    private static final List<Map.Entry<Key, Value>> LAST_BATCH = new ArrayList<Map.Entry<Key, Value>>();
    private final Object nextLock = new Object();
    private long failSleepTime = 100L;
    private volatile Throwable fatalException = null;
    private Map<String, TimeoutTracker> timeoutTrackers;
    private Set<String> timedoutServers;
    private final long retryTimeout;
    private TabletLocator locator;
    private ScanServerAttemptsImpl scanAttempts = new ScanServerAttemptsImpl();

    public TabletServerBatchReaderIterator(ClientContext context, TableId tableId, String tableName, Authorizations authorizations, ArrayList<Range> ranges, int numThreads, ExecutorService queryThreadPool, ScannerOptions scannerOptions, long retryTimeout) {
        this.context = context;
        this.tableId = tableId;
        this.tableName = tableName;
        this.authorizations = authorizations;
        this.numThreads = numThreads;
        this.queryThreadPool = queryThreadPool;
        this.options = new ScannerOptions(scannerOptions);
        this.resultsQueue = new ArrayBlockingQueue(numThreads);
        this.locator = new TimeoutTabletLocator(retryTimeout, context, tableId);
        this.timeoutTrackers = Collections.synchronizedMap(new HashMap());
        this.timedoutServers = Collections.synchronizedSet(new HashSet());
        this.retryTimeout = retryTimeout;
        if (!this.options.fetchedColumns.isEmpty()) {
            ArrayList<Range> ranges2 = new ArrayList<Range>(ranges.size());
            for (Range range : ranges) {
                ranges2.add(range.bound(this.options.fetchedColumns.first(), this.options.fetchedColumns.last()));
            }
            ranges = ranges2;
        }
        ResultReceiver rr = entries -> {
            try {
                this.resultsQueue.put(entries);
            }
            catch (InterruptedException e) {
                if (this.queryThreadPool.isShutdown()) {
                    log.debug("Failed to add Batch Scan result", (Throwable)e);
                } else {
                    log.warn("Failed to add Batch Scan result", (Throwable)e);
                }
                this.fatalException = e;
                throw new IllegalStateException(e);
            }
        };
        try {
            this.lookup(ranges, rr);
        }
        catch (AccumuloException | AccumuloSecurityException | TableNotFoundException e) {
            throw new IllegalStateException("Failed to create iterator", e);
        }
    }

    @Override
    public boolean hasNext() {
        Object object = this.nextLock;
        synchronized (object) {
            if (this.batch == LAST_BATCH) {
                return false;
            }
            if (this.batch != null && this.batchIterator.hasNext()) {
                return true;
            }
            try {
                this.batch = null;
                while (this.batch == null && this.fatalException == null && !this.queryThreadPool.isShutdown()) {
                    this.batch = this.resultsQueue.poll(1L, TimeUnit.SECONDS);
                }
                if (this.fatalException != null) {
                    if (this.fatalException instanceof RuntimeException) {
                        throw (RuntimeException)this.fatalException;
                    }
                    throw new IllegalStateException(this.fatalException);
                }
                if (this.queryThreadPool.isShutdown()) {
                    String shortMsg = "The BatchScanner was unexpectedly closed while this Iterator was still in use.";
                    log.error("{} Ensure that a reference to the BatchScanner is retained so that it can be closed when this Iterator is exhausted. Not retaining a reference to the BatchScanner guarantees that you are leaking threads in your client JVM.", (Object)shortMsg);
                    throw new IllegalStateException(shortMsg + " Ensure proper handling of the BatchScanner.");
                }
                this.batchIterator = this.batch.iterator();
                return this.batch != LAST_BATCH;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public Map.Entry<Key, Value> next() {
        Object object = this.nextLock;
        synchronized (object) {
            if (this.hasNext()) {
                return this.batchIterator.next();
            }
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private synchronized void lookup(List<Range> ranges, ResultReceiver receiver) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        ArrayList<Column> columns = new ArrayList<Column>(this.options.fetchedColumns);
        ranges = Range.mergeOverlapping(ranges);
        HashMap<String, Map<KeyExtent, List<Range>>> binnedRanges = new HashMap<String, Map<KeyExtent, List<Range>>>();
        this.binRanges(this.locator, ranges, binnedRanges);
        this.doLookups(binnedRanges, receiver, columns);
    }

    private void binRanges(TabletLocator tabletLocator, List<Range> ranges, Map<String, Map<KeyExtent, List<Range>>> binnedRanges) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        int lastFailureSize = Integer.MAX_VALUE;
        Retry retry = Retry.builder().infiniteRetries().retryAfter(100L, TimeUnit.MILLISECONDS).incrementBy(100L, TimeUnit.MILLISECONDS).maxWait(10L, TimeUnit.SECONDS).backOffFactor(1.07).logInterval(1L, TimeUnit.MINUTES).createFactory().createRetry();
        while (true) {
            binnedRanges.clear();
            List<Range> failures = tabletLocator.binRanges(this.context, ranges, binnedRanges);
            if (failures.isEmpty()) break;
            if (failures.size() >= lastFailureSize) {
                this.context.requireNotDeleted(this.tableId);
                this.context.requireNotOffline(this.tableId, this.tableName);
            }
            lastFailureSize = failures.size();
            if (log.isTraceEnabled()) {
                log.trace("Failed to bin {} ranges, tablet locations were null, retrying in 100ms", (Object)failures.size());
            }
            try {
                retry.waitForNextAttempt(log, "binRanges retry failures");
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        HashMap binnedRanges2 = new HashMap();
        for (Map.Entry<String, Map<KeyExtent, List<Range>>> entry : binnedRanges.entrySet()) {
            HashMap tabletMap = new HashMap();
            binnedRanges2.put(entry.getKey(), tabletMap);
            for (Map.Entry<KeyExtent, List<Range>> tabletRanges : entry.getValue().entrySet()) {
                Range tabletRange = tabletRanges.getKey().toDataRange();
                ArrayList<Range> clippedRanges = new ArrayList<Range>();
                tabletMap.put(tabletRanges.getKey(), clippedRanges);
                for (Range range : tabletRanges.getValue()) {
                    clippedRanges.add(tabletRange.clip(range));
                }
            }
        }
        binnedRanges.clear();
        binnedRanges.putAll(binnedRanges2);
    }

    private void processFailures(Map<KeyExtent, List<Range>> failures, ResultReceiver receiver, List<Column> columns, Duration scanServerSelectorDelay) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        if (log.isTraceEnabled()) {
            log.trace("Failed to execute multiscans against {} tablets, retrying...", (Object)failures.size());
        }
        try {
            if (scanServerSelectorDelay != null) {
                Thread.sleep(scanServerSelectorDelay.toMillis());
            } else {
                Thread.sleep(this.failSleepTime);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.debug("Exiting failure processing on interrupt");
            return;
        }
        this.failSleepTime = Math.min(5000L, this.failSleepTime * 2L);
        HashMap<String, Map<KeyExtent, List<Range>>> binnedRanges = new HashMap<String, Map<KeyExtent, List<Range>>>();
        ArrayList<Range> allRanges = new ArrayList<Range>();
        for (List<Range> ranges : failures.values()) {
            allRanges.addAll(ranges);
        }
        this.binRanges(this.locator, allRanges, binnedRanges);
        this.doLookups(binnedRanges, receiver, columns);
    }

    private String getTableInfo() {
        return this.context.getPrintableTableInfoFromId(this.tableId);
    }

    private void doLookups(Map<String, Map<KeyExtent, List<Range>>> binnedRanges, ResultReceiver receiver, List<Column> columns) {
        int maxTabletsPerRequest = Integer.MAX_VALUE;
        long busyTimeout = 0L;
        Duration scanServerSelectorDelay = null;
        Map<Object, Object> reporters = Map.of();
        if (this.options.getConsistencyLevel().equals((Object)ScannerBase.ConsistencyLevel.EVENTUAL)) {
            ScanServerData scanServerData = this.rebinToScanServers(binnedRanges);
            busyTimeout = scanServerData.actions.getBusyTimeout().toMillis();
            reporters = scanServerData.reporters;
            scanServerSelectorDelay = scanServerData.actions.getDelay();
            binnedRanges = scanServerData.binnedRanges;
        } else if (this.numThreads / binnedRanges.size() > 1) {
            int totalNumberOfTablets = 0;
            for (Map.Entry<String, Map<KeyExtent, List<Range>>> entry : binnedRanges.entrySet()) {
                totalNumberOfTablets += entry.getValue().size();
            }
            maxTabletsPerRequest = totalNumberOfTablets / this.numThreads;
            if (maxTabletsPerRequest == 0) {
                maxTabletsPerRequest = 1;
            }
        }
        log.debug("timed out servers: {}", this.timedoutServers);
        log.debug("binned range servers: {}", binnedRanges.keySet());
        if (this.timedoutServers.containsAll(binnedRanges.keySet())) {
            throw new TimedOutException(this.timedoutServers);
        }
        HashMap<KeyExtent, List<Range>> failures = new HashMap<KeyExtent, List<Range>>();
        if (!this.timedoutServers.isEmpty()) {
            Iterator<Map.Entry<String, Map<KeyExtent, List<Range>>>> iterator = binnedRanges.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Map<KeyExtent, List<Range>>> entry;
                entry = iterator.next();
                if (!this.timedoutServers.contains(entry.getKey())) continue;
                failures.putAll(entry.getValue());
                iterator.remove();
            }
        }
        ArrayList<String> locations = new ArrayList<String>(binnedRanges.keySet());
        Collections.shuffle(locations);
        ArrayList<QueryTask> queryTasks = new ArrayList<QueryTask>();
        for (String tsLocation : locations) {
            Map<KeyExtent, List<Range>> tabletsRanges = binnedRanges.get(tsLocation);
            if (maxTabletsPerRequest == Integer.MAX_VALUE || tabletsRanges.size() == 1) {
                QueryTask queryTask = new QueryTask(tsLocation, tabletsRanges, failures, receiver, columns, busyTimeout, reporters.getOrDefault(tsLocation, r -> {}), scanServerSelectorDelay);
                queryTasks.add(queryTask);
                continue;
            }
            HashMap<KeyExtent, List<Range>> tabletSubset = new HashMap<KeyExtent, List<Range>>();
            for (Map.Entry<KeyExtent, List<Range>> entry : tabletsRanges.entrySet()) {
                tabletSubset.put(entry.getKey(), entry.getValue());
                if (tabletSubset.size() < maxTabletsPerRequest) continue;
                QueryTask queryTask = new QueryTask(tsLocation, tabletSubset, failures, receiver, columns, busyTimeout, (ScanServerAttemptReporter)reporters.getOrDefault(tsLocation, r -> {}), scanServerSelectorDelay);
                queryTasks.add(queryTask);
                tabletSubset = new HashMap();
            }
            if (tabletSubset.isEmpty()) continue;
            QueryTask queryTask = new QueryTask(tsLocation, tabletSubset, failures, receiver, columns, busyTimeout, (ScanServerAttemptReporter)reporters.getOrDefault(tsLocation, r -> {}), scanServerSelectorDelay);
            queryTasks.add(queryTask);
        }
        Semaphore semaphore = new Semaphore(queryTasks.size());
        semaphore.acquireUninterruptibly(queryTasks.size());
        for (QueryTask queryTask : queryTasks) {
            queryTask.setSemaphore(semaphore, queryTasks.size());
            this.queryThreadPool.execute(queryTask);
        }
    }

    private ScanServerData rebinToScanServers(Map<String, Map<KeyExtent, List<Range>>> binnedRanges) {
        ScanServerSelector ecsm = this.context.getScanServerSelector();
        final List tabletIds = binnedRanges.values().stream().flatMap(extentMap -> extentMap.keySet().stream()).map(TabletIdImpl::new).collect(Collectors.toList());
        final Map<TabletId, Collection<ScanServerAttemptImpl>> scanAttemptsSnapshot = this.scanAttempts.snapshot();
        ScanServerSelector.SelectorParameters params = new ScanServerSelector.SelectorParameters(){

            @Override
            public Collection<TabletId> getTablets() {
                return Collections.unmodifiableCollection(tabletIds);
            }

            @Override
            public Collection<? extends ScanServerAttempt> getAttempts(TabletId tabletId) {
                return scanAttemptsSnapshot.getOrDefault(tabletId, Set.of());
            }

            @Override
            public Map<String, String> getHints() {
                return TabletServerBatchReaderIterator.this.options.executionHints;
            }
        };
        ScanServerSelections actions = ecsm.selectServers(params);
        HashMap extentToTserverMap = new HashMap();
        HashMap extentToRangesMap = new HashMap();
        binnedRanges.forEach((server, extentMap) -> extentMap.forEach((extent, ranges) -> {
            extentToTserverMap.put(extent, server);
            extentToRangesMap.put(extent, ranges);
        }));
        HashMap<String, Map<KeyExtent, List<Range>>> binnedRanges2 = new HashMap<String, Map<KeyExtent, List<Range>>>();
        HashMap<String, ScanServerAttemptReporter> reporters = new HashMap<String, ScanServerAttemptReporter>();
        for (TabletIdImpl tabletId : tabletIds) {
            KeyExtent extent = tabletId.toKeyExtent();
            String serverToUse = actions.getScanServer(tabletId);
            if (serverToUse == null) {
                serverToUse = (String)extentToTserverMap.get(extent);
                log.trace("For tablet {} scan server selector chose tablet_server", (Object)tabletId);
            } else {
                log.trace("For tablet {} scan server selector chose scan_server:{}", (Object)tabletId, (Object)serverToUse);
            }
            Map rangeMap = binnedRanges2.computeIfAbsent(serverToUse, k -> new HashMap());
            List ranges = (List)extentToRangesMap.get(extent);
            rangeMap.put(extent, ranges);
            String server2 = serverToUse;
            reporters.computeIfAbsent(serverToUse, k -> this.scanAttempts.createReporter(server2, tabletId));
        }
        ScanServerData ssd = new ScanServerData();
        ssd.binnedRanges = binnedRanges2;
        ssd.actions = actions;
        ssd.reporters = reporters;
        log.trace("Scan server selector chose delay:{} busyTimeout:{}", (Object)actions.getDelay(), (Object)actions.getBusyTimeout());
        return ssd;
    }

    static void trackScanning(Map<KeyExtent, List<Range>> failures, Map<KeyExtent, List<Range>> unscanned, MultiScanResult scanResult) {
        Map<KeyExtent, List> retFailures = scanResult.failures.entrySet().stream().collect(Collectors.toMap(entry -> KeyExtent.fromThrift((TKeyExtent)entry.getKey()), entry -> ((List)entry.getValue()).stream().map(Range::new).collect(Collectors.toList())));
        unscanned.keySet().removeAll(retFailures.keySet());
        failures.putAll(retFailures);
        Set fullScans = scanResult.fullScans.stream().map(KeyExtent::fromThrift).collect(Collectors.toSet());
        unscanned.keySet().removeAll(fullScans);
        if (scanResult.partScan != null) {
            KeyExtent ke = KeyExtent.fromThrift(scanResult.partScan);
            Key nextKey = new Key(scanResult.partNextKey);
            ListIterator<Range> iterator = unscanned.get(ke).listIterator();
            while (iterator.hasNext()) {
                Range range = iterator.next();
                if (range.afterEndKey(nextKey) || nextKey.equals(range.getEndKey()) && scanResult.partNextKeyInclusive != range.isEndKeyInclusive()) {
                    iterator.remove();
                    continue;
                }
                if (!range.contains(nextKey)) continue;
                iterator.remove();
                Range partRange = new Range(nextKey, scanResult.partNextKeyInclusive, range.getEndKey(), range.isEndKeyInclusive());
                iterator.add(partRange);
            }
        }
    }

    public static void doLookup(ClientContext context, String server, Map<KeyExtent, List<Range>> requested, Map<KeyExtent, List<Range>> failures, Map<KeyExtent, List<Range>> unscanned, ResultReceiver receiver, List<Column> columns, ScannerOptions options, Authorizations authorizations) throws IOException, AccumuloSecurityException, AccumuloServerException {
        TabletServerBatchReaderIterator.doLookup(context, server, requested, failures, unscanned, receiver, columns, options, authorizations, new TimeoutTracker(Long.MAX_VALUE), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doLookup(ClientContext context, String server, Map<KeyExtent, List<Range>> requested, Map<KeyExtent, List<Range>> failures, Map<KeyExtent, List<Range>> unscanned, ResultReceiver receiver, List<Column> columns, ScannerOptions options, Authorizations authorizations, TimeoutTracker timeoutTracker, long busyTimeout) throws IOException, AccumuloSecurityException, AccumuloServerException {
        if (requested.isEmpty()) {
            return;
        }
        for (Map.Entry<KeyExtent, List<Range>> entry2 : requested.entrySet()) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (Range range : entry2.getValue()) {
                ranges.add(new Range(range));
            }
            unscanned.put(KeyExtent.copyOf(entry2.getKey()), ranges);
        }
        timeoutTracker.startingScan();
        try {
            HostAndPort parsedServer = HostAndPort.fromString((String)server);
            TabletScanClientService.Client client = timeoutTracker.getTimeOut() < context.getClientTimeoutInMillis() ? ThriftUtil.getClient(ThriftClientTypes.TABLET_SCAN, parsedServer, context, timeoutTracker.getTimeOut()) : ThriftUtil.getClient(ThriftClientTypes.TABLET_SCAN, parsedServer, context);
            try {
                TabletType ttype;
                OpTimer timer = null;
                if (log.isTraceEnabled()) {
                    log.trace("tid={} Starting multi scan, tserver={}  #tablets={}  #ranges={} ssil={} ssio={}", new Object[]{Thread.currentThread().getId(), server, requested.size(), TabletServerBatchReaderIterator.sumSizes(requested.values()), options.serverSideIteratorList, options.serverSideIteratorOptions});
                    timer = new OpTimer().start();
                }
                boolean waitForWrites = !ThriftScanner.serversWaitedForWrites.get((Object)(ttype = TabletType.type(requested.keySet()))).contains(server);
                Map<TKeyExtent, List<TRange>> thriftTabletRanges = requested.entrySet().stream().collect(Collectors.toMap(entry -> ((KeyExtent)entry.getKey()).toThrift(), entry -> ((List)entry.getValue()).stream().map(Range::toThrift).collect(Collectors.toList())));
                Map<String, String> execHints = options.executionHints.isEmpty() ? null : options.executionHints;
                InitialMultiScan imsr = client.startMultiScan(TraceUtil.traceInfo(), context.rpcCreds(), thriftTabletRanges, columns.stream().map(Column::toThrift).collect(Collectors.toList()), options.serverSideIteratorList, options.serverSideIteratorOptions, ByteBufferUtil.toByteBuffers(authorizations.getAuthorizations()), waitForWrites, SamplerConfigurationImpl.toThrift(options.getSamplerConfiguration()), options.batchTimeout, options.classLoaderContext, execHints, busyTimeout);
                if (waitForWrites) {
                    ThriftScanner.serversWaitedForWrites.get((Object)ttype).add(server.toString());
                }
                MultiScanResult scanResult = imsr.result;
                if (timer != null) {
                    timer.stop();
                    log.trace("tid={} Got 1st multi scan results, #results={} {} in {}", new Object[]{Thread.currentThread().getId(), scanResult.results.size(), scanResult.more ? "scanID=" + imsr.scanID : "", String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
                }
                ArrayList<Map.Entry<Key, Value>> entries = new ArrayList<Map.Entry<Key, Value>>(scanResult.results.size());
                for (TKeyValue kv : scanResult.results) {
                    entries.add(new AbstractMap.SimpleImmutableEntry<Key, Value>(new Key(kv.key), new Value(kv.value)));
                }
                if (!entries.isEmpty()) {
                    receiver.receive(entries);
                }
                if (!entries.isEmpty() || !scanResult.fullScans.isEmpty()) {
                    timeoutTracker.madeProgress();
                }
                TabletServerBatchReaderIterator.trackScanning(failures, unscanned, scanResult);
                AtomicLong nextOpid = new AtomicLong();
                while (scanResult.more) {
                    timeoutTracker.check();
                    if (timer != null) {
                        log.trace("tid={} oid={} Continuing multi scan, scanid={}", new Object[]{Thread.currentThread().getId(), nextOpid.get(), imsr.scanID});
                        timer.reset().start();
                    }
                    scanResult = client.continueMultiScan(TraceUtil.traceInfo(), imsr.scanID, busyTimeout);
                    if (timer != null) {
                        timer.stop();
                        log.trace("tid={} oid={} Got more multi scan results, #results={} {} in {}", new Object[]{Thread.currentThread().getId(), nextOpid.getAndIncrement(), scanResult.results.size(), scanResult.more ? " scanID=" + imsr.scanID : "", String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
                    }
                    entries = new ArrayList(scanResult.results.size());
                    for (TKeyValue kv : scanResult.results) {
                        entries.add(new AbstractMap.SimpleImmutableEntry<Key, Value>(new Key(kv.key), new Value(kv.value)));
                    }
                    if (!entries.isEmpty()) {
                        receiver.receive(entries);
                    }
                    if (!entries.isEmpty() || !scanResult.fullScans.isEmpty()) {
                        timeoutTracker.madeProgress();
                    }
                    TabletServerBatchReaderIterator.trackScanning(failures, unscanned, scanResult);
                }
                client.closeMultiScan(TraceUtil.traceInfo(), imsr.scanID);
            }
            finally {
                ThriftUtil.returnClient(client, context);
            }
        }
        catch (TTransportException e) {
            log.debug("Server : {} msg : {}", (Object)server, (Object)e.getMessage());
            timeoutTracker.errorOccured();
            throw new IOException(e);
        }
        catch (ThriftSecurityException e) {
            log.debug("Server : {} msg : {}", new Object[]{server, e.getMessage(), e});
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (TApplicationException e) {
            log.debug("Server : {} msg : {}", new Object[]{server, e.getMessage(), e});
            throw new AccumuloServerException(server, e);
        }
        catch (NoSuchScanIDException e) {
            log.debug("Server : {} msg : {}", new Object[]{server, e.getMessage(), e});
            throw new IOException((Throwable)((Object)e));
        }
        catch (ScanServerBusyException e) {
            log.debug("Server : {} msg : {}", new Object[]{server, e.getMessage(), e});
            throw new IOException((Throwable)((Object)e));
        }
        catch (TSampleNotPresentException e) {
            log.debug("Server : " + server + " msg : " + e.getMessage(), (Throwable)((Object)e));
            String tableInfo = "?";
            if (e.getExtent() != null) {
                TableId tableId = KeyExtent.fromThrift(e.getExtent()).tableId();
                tableInfo = context.getPrintableTableInfoFromId(tableId);
            }
            String message = "Table " + tableInfo + " does not have sampling configured or built";
            throw new SampleNotPresentException(message, (Exception)((Object)e));
        }
        catch (TException e) {
            log.debug("Server : {} msg : {}", new Object[]{server, e.getMessage(), e});
            timeoutTracker.errorOccured();
            throw new IOException(e);
        }
    }

    static int sumSizes(Collection<List<Range>> values) {
        int sum = 0;
        for (List<Range> list : values) {
            sum += list.size();
        }
        return sum;
    }

    private static class TimeoutTracker {
        String server;
        Set<String> badServers;
        long timeOut;
        long activityTime;
        Long firstErrorTime = null;

        TimeoutTracker(String server, Set<String> badServers, long timeOut) {
            this(timeOut);
            this.server = server;
            this.badServers = badServers;
        }

        TimeoutTracker(long timeOut) {
            this.timeOut = timeOut;
        }

        void startingScan() {
            this.activityTime = System.currentTimeMillis();
        }

        void check() throws IOException {
            if (System.currentTimeMillis() - this.activityTime > this.timeOut) {
                this.badServers.add(this.server);
                throw new IOException("Time exceeded " + (System.currentTimeMillis() - this.activityTime) + " " + this.server);
            }
        }

        void madeProgress() {
            this.activityTime = System.currentTimeMillis();
            this.firstErrorTime = null;
        }

        void errorOccured() {
            if (this.firstErrorTime == null) {
                this.firstErrorTime = this.activityTime;
            } else if (System.currentTimeMillis() - this.firstErrorTime > this.timeOut) {
                this.badServers.add(this.server);
            }
        }

        public long getTimeOut() {
            return this.timeOut;
        }
    }

    private static class ScanServerData {
        Map<String, Map<KeyExtent, List<Range>>> binnedRanges;
        ScanServerSelections actions;
        Map<String, ScanServerAttemptReporter> reporters;

        private ScanServerData() {
        }
    }

    private class QueryTask
    implements Runnable {
        private String tsLocation;
        private Map<KeyExtent, List<Range>> tabletsRanges;
        private ResultReceiver receiver;
        private Semaphore semaphore = null;
        private final Map<KeyExtent, List<Range>> failures;
        private List<Column> columns;
        private int semaphoreSize;
        private final long busyTimeout;
        private final ScanServerAttemptReporter reporter;
        private final Duration scanServerSelectorDelay;

        QueryTask(String tsLocation, Map<KeyExtent, List<Range>> tabletsRanges, Map<KeyExtent, List<Range>> failures, ResultReceiver receiver, List<Column> columns, long busyTimeout, ScanServerAttemptReporter reporter, Duration scanServerSelectorDelay) {
            this.tsLocation = tsLocation;
            this.tabletsRanges = tabletsRanges;
            this.receiver = receiver;
            this.columns = columns;
            this.failures = failures;
            this.busyTimeout = busyTimeout;
            this.reporter = reporter;
            this.scanServerSelectorDelay = scanServerSelectorDelay;
        }

        void setSemaphore(Semaphore semaphore, int semaphoreSize) {
            this.semaphore = semaphore;
            this.semaphoreSize = semaphoreSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block67: {
                String threadName = Thread.currentThread().getName();
                Thread.currentThread().setName(threadName + " looking up " + this.tabletsRanges.size() + " ranges at " + this.tsLocation);
                log.debug("looking up {} ranges at {}", (Object)this.tabletsRanges.size(), (Object)this.tsLocation);
                HashMap<KeyExtent, List<Range>> unscanned = new HashMap<KeyExtent, List<Range>>();
                HashMap<KeyExtent, List<Range>> tsFailures = new HashMap<KeyExtent, List<Range>>();
                try {
                    TimeoutTracker timeoutTracker = TabletServerBatchReaderIterator.this.timeoutTrackers.get(this.tsLocation);
                    if (timeoutTracker == null) {
                        timeoutTracker = new TimeoutTracker(this.tsLocation, TabletServerBatchReaderIterator.this.timedoutServers, TabletServerBatchReaderIterator.this.retryTimeout);
                        TabletServerBatchReaderIterator.this.timeoutTrackers.put(this.tsLocation, timeoutTracker);
                    }
                    TabletServerBatchReaderIterator.doLookup(TabletServerBatchReaderIterator.this.context, this.tsLocation, this.tabletsRanges, tsFailures, unscanned, this.receiver, this.columns, TabletServerBatchReaderIterator.this.options, TabletServerBatchReaderIterator.this.authorizations, timeoutTracker, this.busyTimeout);
                    if (tsFailures.isEmpty()) break block67;
                    TabletServerBatchReaderIterator.this.locator.invalidateCache(tsFailures.keySet());
                    Map<KeyExtent, List<Range>> map = this.failures;
                    synchronized (map) {
                        this.failures.putAll(tsFailures);
                    }
                }
                catch (IOException e) {
                    if (!TabletServerBatchReaderIterator.this.queryThreadPool.isShutdown()) {
                        Map<KeyExtent, List<Range>> map = this.failures;
                        synchronized (map) {
                            this.failures.putAll(tsFailures);
                            this.failures.putAll(unscanned);
                        }
                        TabletServerBatchReaderIterator.this.locator.invalidateCache(TabletServerBatchReaderIterator.this.context, this.tsLocation);
                    }
                    log.debug("IOException thrown", (Throwable)e);
                    ScanServerAttempt.Result result = ScanServerAttempt.Result.ERROR;
                    if (e.getCause() instanceof ScanServerBusyException) {
                        result = ScanServerAttempt.Result.BUSY;
                    }
                    this.reporter.report(result);
                }
                catch (AccumuloSecurityException e) {
                    e.setTableInfo(TabletServerBatchReaderIterator.this.getTableInfo());
                    log.debug("AccumuloSecurityException thrown", (Throwable)e);
                    TabletServerBatchReaderIterator.this.context.clearTableListCache();
                    TabletServerBatchReaderIterator.this.fatalException = TabletServerBatchReaderIterator.this.context.tableNodeExists(TabletServerBatchReaderIterator.this.tableId) ? e : new TableDeletedException(TabletServerBatchReaderIterator.this.tableId.canonical());
                }
                catch (SampleNotPresentException e) {
                    TabletServerBatchReaderIterator.this.fatalException = e;
                }
                catch (Exception t) {
                    if (TabletServerBatchReaderIterator.this.queryThreadPool.isShutdown()) {
                        log.debug("Caught exception, but queryThreadPool is shutdown", (Throwable)t);
                    } else {
                        log.warn("Caught exception, but queryThreadPool is not shutdown", (Throwable)t);
                    }
                    TabletServerBatchReaderIterator.this.fatalException = t;
                }
                catch (Throwable t) {
                    TabletServerBatchReaderIterator.this.fatalException = t;
                    throw t;
                }
                finally {
                    block68: {
                        this.semaphore.release();
                        Thread.currentThread().setName(threadName);
                        if (this.semaphore.tryAcquire(this.semaphoreSize)) {
                            if (TabletServerBatchReaderIterator.this.fatalException == null && !this.failures.isEmpty()) {
                                try {
                                    TabletServerBatchReaderIterator.this.processFailures(this.failures, this.receiver, this.columns, this.scanServerSelectorDelay);
                                }
                                catch (AccumuloException | TableNotFoundException e) {
                                    log.debug("{}", (Object)e.getMessage(), (Object)e);
                                    TabletServerBatchReaderIterator.this.fatalException = e;
                                }
                                catch (AccumuloSecurityException e) {
                                    e.setTableInfo(TabletServerBatchReaderIterator.this.getTableInfo());
                                    log.debug("{}", (Object)e.getMessage(), (Object)e);
                                    TabletServerBatchReaderIterator.this.fatalException = e;
                                }
                                catch (Exception t) {
                                    log.debug("{}", (Object)t.getMessage(), (Object)t);
                                    TabletServerBatchReaderIterator.this.fatalException = t;
                                }
                                if (TabletServerBatchReaderIterator.this.fatalException != null && !TabletServerBatchReaderIterator.this.resultsQueue.offer(LAST_BATCH)) {
                                    log.debug("Could not add to result queue after seeing fatalException in processFailures", TabletServerBatchReaderIterator.this.fatalException);
                                }
                            } else if (TabletServerBatchReaderIterator.this.fatalException != null) {
                                if (!TabletServerBatchReaderIterator.this.resultsQueue.offer(LAST_BATCH)) {
                                    log.debug("Could not add to result queue after seeing fatalException", TabletServerBatchReaderIterator.this.fatalException);
                                }
                            } else {
                                try {
                                    TabletServerBatchReaderIterator.this.resultsQueue.put(LAST_BATCH);
                                }
                                catch (InterruptedException e) {
                                    TabletServerBatchReaderIterator.this.fatalException = e;
                                    if (TabletServerBatchReaderIterator.this.resultsQueue.offer(LAST_BATCH)) break block68;
                                    log.debug("Could not add to result queue after seeing fatalException", TabletServerBatchReaderIterator.this.fatalException);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static interface ResultReceiver {
        public void receive(List<Map.Entry<Key, Value>> var1);
    }
}

