/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.replication;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.replication.ReplicaSystemFactory;
import org.apache.accumulo.server.replication.StatusFormatter;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ReplicationUtil {
    private static final Logger log = LoggerFactory.getLogger(ReplicationUtil.class);
    public static final String STATUS_FORMATTER_CLASS_NAME = StatusFormatter.class.getName();
    private final ServerContext context;
    private final ReplicaSystemFactory factory;

    public ReplicationUtil(ServerContext context) {
        this(context, new ReplicaSystemFactory());
    }

    public ReplicationUtil(ServerContext context, ReplicaSystemFactory factory) {
        this.context = context;
        this.factory = factory;
    }

    public int getMaxReplicationThreads(ManagerMonitorInfo mmi) {
        int activeTservers = mmi.getTServerInfoSize();
        int replicationThreadsPerServer = this.context.getConfiguration().getCount(Property.REPLICATION_WORKER_THREADS);
        return activeTservers * replicationThreadsPerServer;
    }

    public Map<String, String> getPeers() {
        HashMap<String, String> peers = new HashMap<String, String>();
        for (Map.Entry property : this.context.getConfiguration().getAllPropertiesWithPrefix(Property.REPLICATION_PEERS).entrySet()) {
            Map.Entry<String, String> entry;
            String key = (String)property.getKey();
            if (key.startsWith(Property.REPLICATION_PEER_USER.getKey()) || key.startsWith(Property.REPLICATION_PEER_PASSWORD.getKey()) || key.startsWith(Property.REPLICATION_PEER_KEYTAB.getKey())) continue;
            String peerName = ((String)property.getKey()).substring(Property.REPLICATION_PEERS.getKey().length());
            try {
                entry = this.factory.parseReplicaSystemConfiguration((String)property.getValue());
            }
            catch (Exception e) {
                log.warn("Could not instantiate ReplicaSystem for {} with configuration {}", new Object[]{property.getKey(), property.getValue(), e});
                continue;
            }
            peers.put(peerName, entry.getKey());
        }
        return peers;
    }

    public Set<ReplicationTarget> getReplicationTargets() {
        HashSet<ReplicationTarget> allConfiguredTargets = new HashSet<ReplicationTarget>();
        Map tableNameToId = this.context.getTableNameToIdMap();
        for (String table : tableNameToId.keySet()) {
            if (MetadataTable.NAME.equals(table) || RootTable.NAME.equals(table)) continue;
            TableId localId = (TableId)tableNameToId.get(table);
            if (localId == null) {
                log.trace("Could not determine ID for {}", (Object)table);
                continue;
            }
            TableConfiguration tableConf = this.context.getTableConfiguration(localId);
            if (tableConf == null) {
                log.trace("Could not get configuration for table {} (it no longer exists)", (Object)table);
                continue;
            }
            for (Map.Entry prop : tableConf.getAllPropertiesWithPrefix(Property.TABLE_REPLICATION_TARGET).entrySet()) {
                String peerName = ((String)prop.getKey()).substring(Property.TABLE_REPLICATION_TARGET.getKey().length());
                String remoteIdentifier = (String)prop.getValue();
                ReplicationTarget target = new ReplicationTarget(peerName, remoteIdentifier, localId);
                allConfiguredTargets.add(target);
            }
        }
        return allConfiguredTargets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ReplicationTarget, Long> getPendingReplications() {
        BatchScanner bs;
        HashMap<ReplicationTarget, Long> counts = new HashMap<ReplicationTarget, Long>();
        try {
            bs = this.context.createBatchScanner(ReplicationTable.NAME, Authorizations.EMPTY, 4);
        }
        catch (TableNotFoundException e) {
            log.debug("No replication table exists", (Throwable)e);
            return counts;
        }
        bs.setRanges(Collections.singleton(new Range()));
        ReplicationSchema.WorkSection.limit((ScannerBase)bs);
        try {
            Text buffer = new Text();
            for (Map.Entry entry : bs) {
                Key k = (Key)entry.getKey();
                k.getColumnQualifier(buffer);
                ReplicationTarget target = ReplicationTarget.from((Text)buffer);
                Long count = (Long)counts.get(target);
                if (count == null) {
                    counts.put(target, 1L);
                    continue;
                }
                counts.put(target, count + 1L);
            }
        }
        finally {
            bs.close();
        }
        return counts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Path> getPendingReplicationPaths() {
        BatchScanner bs;
        HashSet<Path> paths = new HashSet<Path>();
        try {
            bs = this.context.createBatchScanner(ReplicationTable.NAME, Authorizations.EMPTY, 4);
        }
        catch (TableNotFoundException e) {
            log.debug("No replication table exists", (Throwable)e);
            return paths;
        }
        bs.setRanges(Collections.singleton(new Range()));
        ReplicationSchema.StatusSection.limit((ScannerBase)bs);
        try {
            Text buffer = new Text();
            for (Map.Entry entry : bs) {
                Key k = (Key)entry.getKey();
                k.getRow(buffer);
                paths.add(new Path(buffer.toString()));
            }
        }
        finally {
            bs.close();
        }
        return paths;
    }
}

