/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata.schema;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootTabletMetadata {
    private static final Logger log = LoggerFactory.getLogger(RootTabletMetadata.class);
    private static final CharsetDecoder UTF8_error_detecting_decoder = StandardCharsets.UTF_8.newDecoder();
    private static final Predicate<Map.Entry<String, TreeMap<String, String>>> isLocationCF = e -> {
        String fam = (String)e.getKey();
        return fam.equals("loc") || fam.equals("future");
    };
    private static final int VERSION = 1;
    private final Gson gson = new Gson();
    private final Data data;

    private static String bytesToUtf8(byte[] byteSequence) {
        try {
            return UTF8_error_detecting_decoder.decode(ByteBuffer.wrap(byteSequence)).toString();
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RootTabletMetadata(String json) {
        log.trace("Creating root tablet metadata from stored JSON: {}", (Object)json);
        this.data = (Data)this.gson.fromJson(json, Data.class);
        Preconditions.checkArgument((this.data.version == 1 ? 1 : 0) != 0, (String)"Invalid Root Table Metadata JSON version %s", (int)this.data.version);
        this.data.columnValues.forEach((fam, qualVals) -> {
            Preconditions.checkArgument((!fam.isBlank() ? 1 : 0) != 0, (String)"Blank column family in %s", this.data.columnValues);
            Preconditions.checkArgument((!qualVals.isEmpty() ? 1 : 0) != 0, (String)"No columns in family %s", (Object)fam);
        });
    }

    public RootTabletMetadata() {
        this.data = new Data(1, new TreeMap<String, TreeMap<String, String>>());
    }

    public void update(Mutation m) {
        Preconditions.checkArgument((boolean)new Text(m.getRow()).equals((Object)RootTable.EXTENT.toMetaRow()), (Object)("Invalid Root Table Row " + String.valueOf(new Text(m.getRow()))));
        m.getUpdates().forEach(cup -> {
            Preconditions.checkArgument((!cup.hasTimestamp() ? 1 : 0) != 0, (Object)"Root Table timestamp must be empty.");
            Preconditions.checkArgument((cup.getColumnVisibility().length == 0 ? 1 : 0) != 0, (Object)"Root Table visibility must be empty.");
        });
        m.getUpdates().forEach(cup -> {
            String fam = RootTabletMetadata.bytesToUtf8(cup.getColumnFamily());
            String qual = RootTabletMetadata.bytesToUtf8(cup.getColumnQualifier());
            String val = RootTabletMetadata.bytesToUtf8(cup.getValue());
            if (cup.isDeleted()) {
                this.data.columnValues.computeIfPresent(fam, (key, qualVals) -> {
                    qualVals.remove(qual);
                    return qualVals.isEmpty() ? null : qualVals;
                });
            } else {
                this.data.columnValues.computeIfAbsent(fam, k -> new TreeMap()).put(qual, val);
            }
        });
        if (this.data.columnValues.entrySet().stream().filter(isLocationCF).map(Map.Entry::getValue).mapToInt(TreeMap::size).sum() > 1) {
            throw new IllegalStateException("After mutation, root tablet has multiple locations : " + String.valueOf(m) + " " + String.valueOf(this.data.columnValues));
        }
    }

    public TabletMetadata toTabletMetadata() {
        String row = RootTable.EXTENT.toMetaRow().toString();
        Stream entries = this.data.columnValues.entrySet().stream().flatMap(famToQualVal -> ((TreeMap)famToQualVal.getValue()).entrySet().stream().map(qualVal -> new AbstractMap.SimpleImmutableEntry<Key, Value>(new Key((CharSequence)row, (CharSequence)famToQualVal.getKey(), (CharSequence)qualVal.getKey(), 1L), new Value((CharSequence)qualVal.getValue()))));
        return TabletMetadata.convertRow(entries.iterator(), EnumSet.allOf(TabletMetadata.ColumnType.class), false);
    }

    public String toJson() {
        return this.gson.toJson((Object)this.data);
    }

    private static class Data {
        private final int version;
        private final TreeMap<String, TreeMap<String, String>> columnValues;

        public Data(int version, TreeMap<String, TreeMap<String, String>> columnValues) {
            this.version = version;
            this.columnValues = columnValues;
        }
    }
}

