/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.start;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.accumulo.start.classloader.AccumuloClassLoader;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static ClassLoader classLoader;
    private static Class<?> vfsClassLoader;
    private static Map<String, KeywordExecutable> servicesMap;

    public static void main(String[] args) throws Exception {
        ClassLoader loader = Main.getClassLoader();
        Class<?> confClass = null;
        try {
            Class<?> deprecatedConfClass;
            confClass = deprecatedConfClass = AccumuloClassLoader.getClassLoader().loadClass("org.apache.hadoop.conf.Configuration");
            Object conf = null;
            try {
                conf = confClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                try {
                    Method getClassByNameOrNullMethod = conf.getClass().getMethod("getClassByNameOrNull", String.class);
                    getClassByNameOrNullMethod.invoke(conf, "org.apache.hadoop.mapred.JobConf");
                    getClassByNameOrNullMethod.invoke(conf, "org.apache.hadoop.mapred.JobConfigurable");
                }
                catch (Exception e) {
                    Main.die(e, "Error pre-loading JobConf and JobConfigurable classes, VFS classloader with system classes in HDFS may not work correctly");
                }
            }
            catch (Exception e) {
                Main.die(e, "Error creating new instance of Hadoop Configuration");
            }
        }
        catch (ClassNotFoundException e) {
            Main.die(e, "Unable to find Hadoop Configuration class on classpath, check configuration.");
        }
        if (args.length == 0) {
            Main.printUsage();
            System.exit(1);
        }
        if (args[0].equals("-h") || args[0].equals("-help") || args[0].equals("--help")) {
            Main.printUsage();
            return;
        }
        String keywordOrClassName = args[0];
        KeywordExecutable keywordExec = Main.getExecutables(loader).get(keywordOrClassName);
        if (keywordExec != null) {
            Main.execKeyword(keywordExec, Main.stripArgs(args, 1));
        } else {
            Main.execMainClassName(keywordOrClassName, Main.stripArgs(args, 1));
        }
    }

    public static synchronized ClassLoader getClassLoader() {
        if (classLoader == null) {
            try {
                classLoader = (ClassLoader)Main.getVFSClassLoader().getMethod("getClassLoader", new Class[0]).invoke(null, new Object[0]);
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            catch (IOException | IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                Main.die(e, "Problem initializing the class loader");
            }
        }
        return classLoader;
    }

    @Deprecated
    private static synchronized Class<?> getVFSClassLoader() throws IOException, ClassNotFoundException {
        if (vfsClassLoader == null) {
            Thread.currentThread().setContextClassLoader(AccumuloClassLoader.getClassLoader());
            vfsClassLoader = AccumuloClassLoader.getClassLoader().loadClass("org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader");
        }
        return vfsClassLoader;
    }

    private static void execKeyword(KeywordExecutable keywordExec, String[] args) {
        Runnable r = () -> {
            try {
                keywordExec.execute(args);
            }
            catch (Exception e) {
                Main.die(e, null);
            }
        };
        Main.startThread(r, keywordExec.keyword());
    }

    private static void execMainClassName(String className, String[] args) {
        Class<?> classWithMain = null;
        try {
            classWithMain = Main.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("Invalid argument: Java <main class> '" + className + "' was not found.  Please use the wholly qualified package name.");
            Main.printUsage();
            System.exit(1);
        }
        Main.execMainClass(classWithMain, args);
    }

    public static void execMainClass(Class<?> classWithMain, String[] args) {
        Method main = null;
        try {
            main = classWithMain.getMethod("main", args.getClass());
        }
        catch (Exception t) {
            Main.die(t, "Could not run main method on '" + classWithMain.getName() + "'.");
        }
        if (main == null || !Modifier.isPublic(main.getModifiers()) || !Modifier.isStatic(main.getModifiers())) {
            System.out.println(classWithMain.getName() + " must implement a public static void main(String args[]) method");
            System.exit(1);
        }
        Method finalMain = main;
        Runnable r = () -> {
            try {
                finalMain.invoke(null, new Object[]{args});
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    Main.die(e.getCause(), null);
                } else {
                    Main.die(e, null);
                }
            }
            catch (Exception e) {
                Main.die(e, null);
            }
        };
        Main.startThread(r, classWithMain.getName());
    }

    public static String[] stripArgs(String[] originalArgs, int numToStrip) {
        int newSize = originalArgs.length - numToStrip;
        String[] newArgs = new String[newSize];
        System.arraycopy(originalArgs, numToStrip, newArgs, 0, newSize);
        return newArgs;
    }

    private static void startThread(Runnable r, String name) {
        Thread t = new Thread(r, name);
        t.setContextClassLoader(Main.getClassLoader());
        t.start();
    }

    private static void die(Throwable t, String msg) {
        String message = msg == null ? "Thread '" + Thread.currentThread().getName() + "' died." : msg;
        System.err.println(message);
        t.printStackTrace();
        log.error(message, t);
        System.exit(1);
    }

    public static void printCommands(TreeSet<KeywordExecutable> set, KeywordExecutable.UsageGroup group) {
        set.stream().filter(e -> e.usageGroup() == group).forEach(ke -> System.out.printf("  %-30s %s\n", ke.usage(), ke.description()));
    }

    public static void printUsage() {
        TreeSet<KeywordExecutable> executables = new TreeSet<KeywordExecutable>(Comparator.comparing(KeywordExecutable::keyword));
        executables.addAll(Main.getExecutables(Main.getClassLoader()).values());
        System.out.println("\nUsage: accumulo <command> [--help] (<argument> ...)\n\n  --help   Prints usage for specified command");
        System.out.println("\nCore Commands:");
        Main.printCommands(executables, KeywordExecutable.UsageGroup.CORE);
        System.out.println("  jshell                         Runs JShell for Accumulo\n  classpath                      Prints Accumulo classpath\n  <main class> args              Runs Java <main class> located on Accumulo classpath");
        System.out.println("\nProcess Commands:");
        Main.printCommands(executables, KeywordExecutable.UsageGroup.PROCESS);
        System.out.println("\nOther Commands:");
        Main.printCommands(executables, KeywordExecutable.UsageGroup.OTHER);
        System.out.println();
    }

    public static synchronized Map<String, KeywordExecutable> getExecutables(ClassLoader cl) {
        if (servicesMap == null) {
            servicesMap = Main.checkDuplicates(ServiceLoader.load(KeywordExecutable.class, cl));
        }
        return servicesMap;
    }

    public static Map<String, KeywordExecutable> checkDuplicates(Iterable<? extends KeywordExecutable> services) {
        TreeSet<String> banList = new TreeSet<String>();
        TreeMap<String, KeywordExecutable> results = new TreeMap<String, KeywordExecutable>();
        for (KeywordExecutable keywordExecutable : services) {
            String keyword = keywordExecutable.keyword();
            if (banList.contains(keyword)) {
                Main.warnDuplicate(keywordExecutable);
                continue;
            }
            if (results.containsKey(keyword)) {
                banList.add(keyword);
                Main.warnDuplicate((KeywordExecutable)results.remove(keyword));
                Main.warnDuplicate(keywordExecutable);
                continue;
            }
            results.put(keywordExecutable.keyword(), keywordExecutable);
        }
        return Collections.unmodifiableSortedMap(results);
    }

    private static void warnDuplicate(KeywordExecutable service) {
        log.warn("Ambiguous duplicate binding for keyword '{}' found: {}", (Object)service.keyword(), (Object)service.getClass().getName());
    }
}

