/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.htrace.wrappers.TraceRunnable;

class CompactionQueue
extends AbstractQueue<TraceRunnable>
implements BlockingQueue<TraceRunnable> {
    private List<TraceRunnable> task = new LinkedList<TraceRunnable>();
    private static final Comparator<TraceRunnable> comparator = new Comparator<TraceRunnable>(){

        @Override
        public int compare(TraceRunnable o1, TraceRunnable o2) {
            return ((Comparable)((Object)o1.getRunnable())).compareTo(o2.getRunnable());
        }
    };

    CompactionQueue() {
    }

    @Override
    public synchronized TraceRunnable poll() {
        if (this.task.size() == 0) {
            return null;
        }
        TraceRunnable min = Collections.min(this.task, comparator);
        Iterator<TraceRunnable> iterator = this.task.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != min) continue;
            iterator.remove();
            return min;
        }
        throw new IllegalStateException("Minimum object found, but not there when removing");
    }

    @Override
    public synchronized TraceRunnable peek() {
        if (this.task.size() == 0) {
            return null;
        }
        TraceRunnable min = Collections.min(this.task, comparator);
        return min;
    }

    @Override
    public synchronized boolean offer(TraceRunnable e) {
        this.task.add(e);
        this.notify();
        return true;
    }

    @Override
    public synchronized void put(TraceRunnable e) throws InterruptedException {
        this.task.add(e);
        this.notify();
    }

    @Override
    public synchronized boolean offer(TraceRunnable e, long timeout, TimeUnit unit) throws InterruptedException {
        this.task.add(e);
        this.notify();
        return true;
    }

    @Override
    public synchronized TraceRunnable take() throws InterruptedException {
        while (this.task.size() == 0) {
            this.wait();
        }
        return this.poll();
    }

    @Override
    public synchronized TraceRunnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.task.size() == 0) {
            this.wait(unit.toMillis(timeout));
        }
        if (this.task.size() == 0) {
            return null;
        }
        return this.poll();
    }

    @Override
    public synchronized int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public synchronized int drainTo(Collection<? super TraceRunnable> c) {
        return this.drainTo(c, this.task.size());
    }

    @Override
    public synchronized int drainTo(Collection<? super TraceRunnable> c, int maxElements) {
        Collections.sort(this.task, comparator);
        int num = Math.min(this.task.size(), maxElements);
        Iterator<TraceRunnable> iter = this.task.iterator();
        for (int i = 0; i < num; ++i) {
            c.add((TraceRunnable)iter.next());
            iter.remove();
        }
        return num;
    }

    @Override
    public synchronized Iterator<TraceRunnable> iterator() {
        Collections.sort(this.task, comparator);
        return this.task.iterator();
    }

    @Override
    public synchronized int size() {
        return this.task.size();
    }

    BlockingQueue<Runnable> asBlockingQueueOfRunnable() {
        return this;
    }
}

