/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.stress.random;

import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.test.stress.random.DataWriter;
import org.apache.accumulo.test.stress.random.RandomByteArrays;
import org.apache.accumulo.test.stress.random.RandomMutations;
import org.apache.accumulo.test.stress.random.RandomWithinRange;
import org.apache.accumulo.test.stress.random.WriteOptions;

public class Write {
    public static void main(String[] args) throws Exception {
        long writeDelay;
        WriteOptions opts = new WriteOptions();
        BatchWriterOpts batch_writer_opts = new BatchWriterOpts();
        opts.parseArgs(Write.class.getName(), args, new Object[]{batch_writer_opts});
        opts.check();
        Connector c = opts.getConnector();
        if (opts.clear_table && c.tableOperations().exists(opts.getTableName())) {
            try {
                c.tableOperations().delete(opts.getTableName());
            }
            catch (TableNotFoundException e) {
                System.err.println("Couldn't delete the table because it doesn't exist any more.");
            }
        }
        if (!c.tableOperations().exists(opts.getTableName())) {
            try {
                c.tableOperations().create(opts.getTableName());
            }
            catch (TableExistsException e) {
                System.err.println("Couldn't create table ourselves, but that's ok. Continuing.");
            }
        }
        if ((writeDelay = opts.write_delay) < 0L) {
            writeDelay = 0L;
        }
        DataWriter dw = new DataWriter(c.createBatchWriter(opts.getTableName(), batch_writer_opts.getBatchWriterConfig()), new RandomMutations(new RandomByteArrays(new RandomWithinRange(opts.row_seed, opts.rowMin(), opts.rowMax())), new RandomByteArrays(new RandomWithinRange(opts.cf_seed, opts.cfMin(), opts.cfMax())), new RandomByteArrays(new RandomWithinRange(opts.cq_seed, opts.cqMin(), opts.cqMax())), new RandomByteArrays(new RandomWithinRange(opts.value_seed, opts.valueMin(), opts.valueMax())), new RandomWithinRange(opts.row_width_seed, opts.rowWidthMin(), opts.rowWidthMax()), opts.max_cells_per_mutation));
        while (true) {
            dw.next();
            if (writeDelay <= 0L) continue;
            Thread.sleep(writeDelay);
        }
    }
}

