/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication.merkle.cli;

import com.beust.jcommander.Parameter;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.accumulo.core.cli.ClientOnRequiredTable;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.replication.merkle.MerkleTree;
import org.apache.accumulo.test.replication.merkle.MerkleTreeNode;
import org.apache.accumulo.test.replication.merkle.RangeSerialization;
import org.apache.commons.codec.binary.Hex;

public class ComputeRootHash {
    public byte[] getHash(ComputeRootHashOpts opts) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, NoSuchAlgorithmException {
        Connector conn = opts.getConnector();
        String table = opts.getTableName();
        return this.getHash(conn, table, opts.getHashName());
    }

    public byte[] getHash(Connector conn, String table, String hashName) throws TableNotFoundException, NoSuchAlgorithmException {
        ArrayList<MerkleTreeNode> leaves = this.getLeaves(conn, table);
        MerkleTree tree = new MerkleTree(leaves, hashName);
        return tree.getRootNode().getHash();
    }

    protected ArrayList<MerkleTreeNode> getLeaves(Connector conn, String tableName) throws TableNotFoundException {
        Scanner s = conn.createScanner(tableName, Authorizations.EMPTY);
        ArrayList<MerkleTreeNode> leaves = new ArrayList<MerkleTreeNode>();
        for (Map.Entry entry : s) {
            Range range = RangeSerialization.toRange((Key)entry.getKey());
            byte[] hash = ((Value)entry.getValue()).get();
            leaves.add(new MerkleTreeNode(range, 0, Collections.emptyList(), hash));
        }
        return leaves;
    }

    public static void main(String[] args) throws Exception {
        ComputeRootHashOpts opts = new ComputeRootHashOpts();
        opts.parseArgs("ComputeRootHash", args, new Object[0]);
        ComputeRootHash computeRootHash = new ComputeRootHash();
        byte[] rootHash = computeRootHash.getHash(opts);
        System.out.println(Hex.encodeHexString((byte[])rootHash));
    }

    public static class ComputeRootHashOpts
    extends ClientOnRequiredTable {
        @Parameter(names={"-hash", "--hash"}, required=true, description="type of hash to use")
        private String hashName;

        public String getHashName() {
            return this.hashName;
        }

        public void setHashName(String hashName) {
            this.hashName = hashName;
        }
    }
}

