/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.collect.Iterables;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore(value="Replication ITs are not stable and not currently maintained")
public class MultiTserverReplicationIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(MultiTserverReplicationIT.class);

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(2);
    }

    @Test
    public void tserverReplicationServicePortsAreAdvertised() throws Exception {
        Connector conn = this.getConnector();
        Instance inst = conn.getInstance();
        conn.tableOperations().create("foo");
        Scanner s = conn.createScanner("foo", Authorizations.EMPTY);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)s));
        ZooReader zreader = new ZooReader(inst.getZooKeepers(), inst.getZooKeepersSessionTimeOut());
        HashSet tserverHost = new HashSet();
        tserverHost.addAll(zreader.getChildren(ZooUtil.getRoot((Instance)inst) + "/tservers"));
        HashSet<HostAndPort> replicationServices = new HashSet<HostAndPort>();
        for (String tserver : tserverHost) {
            try {
                byte[] portData = zreader.getData(ZooUtil.getRoot((Instance)inst) + "/replication/tservers" + "/" + tserver, null);
                HostAndPort replAddress = HostAndPort.fromString((String)new String(portData, StandardCharsets.UTF_8));
                replicationServices.add(replAddress);
            }
            catch (Exception e) {
                log.error("Could not find port for {}", (Object)tserver, (Object)e);
                Assert.fail((String)("Did not find replication port advertisement for " + tserver));
            }
        }
        Assert.assertEquals((String)"Expected an equal number of replication servicers and tservers", (long)tserverHost.size(), (long)replicationServices.size());
    }

    @Test
    public void masterReplicationServicePortsAreAdvertised() throws Exception {
        Connector conn = this.getConnector();
        Instance inst = conn.getInstance();
        conn.tableOperations().create("foo");
        Scanner s = conn.createScanner("foo", Authorizations.EMPTY);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)s));
        ZooReader zreader = new ZooReader(inst.getZooKeepers(), inst.getZooKeepersSessionTimeOut());
        Assert.assertEquals((long)1L, (long)inst.getMasterLocations().size());
        String masterAddr = (String)Iterables.getOnlyElement((Iterable)inst.getMasterLocations());
        String replCoordAddr = new String(zreader.getData(ZooUtil.getRoot((Instance)inst) + "/masters/repl_coord_addr", null), StandardCharsets.UTF_8);
        Assert.assertNotEquals((Object)masterAddr, (Object)replCoordAddr);
        Assert.assertNotEquals((long)0L, (long)HostAndPort.fromString((String)masterAddr).getPort());
        Assert.assertNotEquals((long)0L, (long)HostAndPort.fromString((String)replCoordAddr).getPort());
    }
}

