/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.shard;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.shard.Insert;
import org.apache.hadoop.io.Text;

public class DeleteWord
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        String indexTableName = (String)state.get("indexTableName");
        String docTableName = (String)state.get("docTableName");
        int numPartitions = (Integer)state.get("numPartitions");
        Random rand = (Random)state.get("rand");
        String wordToDelete = Insert.generateRandomWord(rand);
        Scanner scanner = env.getConnector().createScanner(indexTableName, Authorizations.EMPTY);
        scanner.fetchColumnFamily(new Text(wordToDelete));
        ArrayList<Range> documentsToDelete = new ArrayList<Range>();
        for (Map.Entry entry : scanner) {
            documentsToDelete.add(new Range(((Key)entry.getKey()).getColumnQualifier()));
        }
        if (documentsToDelete.size() > 0) {
            BatchScanner bscanner = env.getConnector().createBatchScanner(docTableName, Authorizations.EMPTY, 8);
            bscanner.setRanges(documentsToDelete);
            BatchWriter ibw = env.getMultiTableBatchWriter().getBatchWriter(indexTableName);
            BatchWriter dbw = env.getMultiTableBatchWriter().getBatchWriter(docTableName);
            int count = 0;
            for (Map.Entry entry : bscanner) {
                String docID = ((Key)entry.getKey()).getRow().toString();
                String doc = ((Value)entry.getValue()).toString();
                Insert.unindexDocument(ibw, doc, docID, numPartitions);
                Mutation m = new Mutation((CharSequence)docID);
                m.putDelete((CharSequence)"doc", (CharSequence)"");
                dbw.addMutation(m);
                ++count;
            }
            bscanner.close();
            env.getMultiTableBatchWriter().flush();
            if (count != documentsToDelete.size()) {
                throw new Exception("Batch scanner did not return expected number of docs " + count + " " + documentsToDelete.size());
            }
        }
        this.log.debug((Object)("Deleted " + documentsToDelete.size() + " documents containing " + wordToDelete));
    }
}

