/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.sequential;

import java.util.Map;
import java.util.Properties;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.sequential.MapRedVerifyTool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class MapRedVerify
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        String[] args = new String[8];
        args[0] = "-libjars";
        args[1] = this.getMapReduceJars();
        args[2] = env.getUserName();
        args[3] = env.getPassword();
        if (null == args[3]) {
            args[3] = env.getKeytab();
        }
        args[4] = state.getString("seqTableName");
        args[5] = env.getInstance().getInstanceName();
        args[6] = env.getConfigProperty("ZOOKEEPERS");
        args[7] = args[4] + "_MR";
        if (ToolRunner.run((Configuration)CachedConfiguration.getInstance(), (Tool)new MapRedVerifyTool(), (String[])args) != 0) {
            this.log.error((Object)"Failed to run map/red verify");
            return;
        }
        Scanner outputScanner = env.getConnector().createScanner(args[7], Authorizations.EMPTY);
        outputScanner.setRange(new Range());
        int count = 0;
        Key lastKey = null;
        for (Map.Entry entry : outputScanner) {
            Key current = (Key)entry.getKey();
            if (lastKey != null && lastKey.getColumnFamily().equals((Object)current.getRow())) {
                this.log.info(entry.getKey());
                ++count;
            }
            lastKey = current;
        }
        if (count > 1) {
            this.log.error((Object)"Gaps in output");
        }
        this.log.debug((Object)("Dropping table: " + args[7]));
        Connector conn = env.getConnector();
        conn.tableOperations().delete(args[7]);
    }
}

