/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class CreateTable
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Connector conn = env.getConnector();
        Random rand = (Random)state.get("rand");
        List tableNames = (List)state.get("tables");
        String tableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        try {
            conn.tableOperations().create(tableName);
            this.log.debug((Object)("Created table " + tableName));
        }
        catch (TableExistsException e) {
            this.log.debug((Object)("Create " + tableName + " failed, it exists"));
        }
        catch (AccumuloException e) {
            if (e.getCause() != null && e.getCause() instanceof NamespaceNotFoundException) {
                this.log.debug((Object)("Create " + tableName + " failed, the namespace does not exist"));
            }
            throw e;
        }
        catch (IllegalArgumentException e) {
            this.log.debug((Object)("Create: " + e.toString()));
        }
        catch (AccumuloSecurityException e) {
            this.log.debug((Object)("Could not create table: " + (Object)((Object)e)));
        }
    }
}

