/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class CloneTable
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Connector conn = env.getConnector();
        Random rand = (Random)state.get("rand");
        List tableNames = (List)state.get("tables");
        String srcTableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        String newTableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        boolean flush = rand.nextBoolean();
        try {
            this.log.debug((Object)("Cloning table " + srcTableName + " " + newTableName + " " + flush));
            conn.tableOperations().clone(srcTableName, newTableName, flush, new HashMap(), new HashSet());
        }
        catch (TableExistsException e) {
            this.log.debug((Object)("Clone " + srcTableName + " failed, " + newTableName + " exists"));
        }
        catch (TableNotFoundException e) {
            this.log.debug((Object)("Clone " + srcTableName + " failed, doesnt exist"));
        }
        catch (IllegalArgumentException e) {
            this.log.debug((Object)("Clone: " + e.toString()));
        }
        catch (AccumuloException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof NamespaceNotFoundException) {
                this.log.debug((Object)("Clone: " + srcTableName + " to " + newTableName + " failed, namespace not found"));
            }
            throw e;
        }
    }
}

