/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.ActiveScan;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanIdIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(ScanIdIT.class);
    private static final int NUM_SCANNERS = 8;
    private static final int NUM_DATA_ROWS = 100;
    private static final Random random = new Random();
    private static final ExecutorService pool = Executors.newFixedThreadPool(8);
    private static final AtomicBoolean testInProgress = new AtomicBoolean(true);
    private static final Map<Integer, Value> resultsByWorker = new ConcurrentHashMap<Integer, Value>();

    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void testScanId() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        Connector conn = this.getConnector();
        conn.tableOperations().create(tableName);
        this.addSplits(conn, tableName);
        log.info("Splits added");
        this.generateSampleData(conn, tableName);
        log.info("Generated data for {}", (Object)tableName);
        this.attachSlowIterator(conn, tableName);
        CountDownLatch latch = new CountDownLatch(8);
        for (int scannerIndex = 0; scannerIndex < 8; ++scannerIndex) {
            ScannerThread st = new ScannerThread(conn, scannerIndex, tableName, latch);
            pool.submit(st);
        }
        while (testInProgress.get()) {
            if (resultsByWorker.size() < 8) {
                log.trace("Results reported {}", (Object)resultsByWorker.size());
                UtilWaitThread.sleepUninterruptibly((long)750L, (TimeUnit)TimeUnit.MILLISECONDS);
                continue;
            }
            testInProgress.set(false);
            log.debug("Final result count {}", (Object)resultsByWorker.size());
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        HashSet<Long> scanIds = new HashSet<Long>();
        List tservers = conn.instanceOperations().getTabletServers();
        log.debug("tablet servers {}", (Object)tservers.toString());
        for (String tserver : tservers) {
            List activeScans = null;
            for (int i = 0; i < 10; ++i) {
                try {
                    activeScans = conn.instanceOperations().getActiveScans(tserver);
                    break;
                }
                catch (AccumuloException e) {
                    if (!(e.getCause() instanceof TableNotFoundException)) {
                        throw e;
                    }
                    log.debug("Got TableNotFoundException, will retry");
                    Thread.sleep(200L);
                    continue;
                }
            }
            Assert.assertNotNull((String)"Repeatedly got exception trying to active scans", activeScans);
            log.debug("TServer {} has {} active scans", (Object)tserver, (Object)activeScans.size());
            for (ActiveScan scan : activeScans) {
                log.debug("Tserver {} scan id {}", (Object)tserver, (Object)scan.getScanid());
                scanIds.add(scan.getScanid());
            }
        }
        Assert.assertTrue((String)("Expected at least 8 scanIds, but saw " + scanIds.size()), (8 <= scanIds.size() ? 1 : 0) != 0);
    }

    private void addSplits(Connector conn, String tableName) {
        SortedSet<Text> splits = this.createSplits();
        try {
            conn.tableOperations().addSplits(tableName, splits);
            conn.tableOperations().offline(tableName, true);
            UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
            conn.tableOperations().online(tableName, true);
            for (Text split : conn.tableOperations().listSplits(tableName)) {
                log.trace("Split {}", (Object)split);
            }
        }
        catch (AccumuloSecurityException e) {
            throw new IllegalStateException("Initialization failed. Could not add splits to " + tableName, e);
        }
        catch (TableNotFoundException e) {
            throw new IllegalStateException("Initialization failed. Could not add splits to " + tableName, e);
        }
        catch (AccumuloException e) {
            throw new IllegalStateException("Initialization failed. Could not add splits to " + tableName, e);
        }
    }

    private SortedSet<Text> createSplits() {
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int split = 0; split < 10; ++split) {
            splits.add(new Text(Integer.toString(split)));
        }
        return splits;
    }

    private void generateSampleData(Connector connector, String tablename) {
        try {
            BatchWriter bw = connector.createBatchWriter(tablename, new BatchWriterConfig());
            ColumnVisibility vis = new ColumnVisibility("public");
            for (int i = 0; i < 100; ++i) {
                Text rowId = new Text(String.format("%d", random.nextInt(10) * 100 + i));
                Mutation m = new Mutation(rowId);
                m.put(new Text("fam1"), new Text("count"), new Value(Integer.toString(i).getBytes(StandardCharsets.UTF_8)));
                m.put(new Text("fam1"), new Text("positive"), vis, new Value(Integer.toString(100 - i).getBytes(StandardCharsets.UTF_8)));
                m.put(new Text("fam1"), new Text("negative"), vis, new Value(Integer.toString(i - 100).getBytes(StandardCharsets.UTF_8)));
                log.trace("Added row {}", (Object)rowId);
                bw.addMutation(m);
            }
            bw.close();
        }
        catch (TableNotFoundException ex) {
            throw new IllegalStateException("Initialization failed. Could not create test data", ex);
        }
        catch (MutationsRejectedException ex) {
            throw new IllegalStateException("Initialization failed. Could not create test data", ex);
        }
    }

    private void attachSlowIterator(Connector connector, String tablename) {
        try {
            IteratorSetting slowIter = new IteratorSetting(50, "slowIter", "org.apache.accumulo.test.functional.SlowIterator");
            slowIter.addOption("sleepTime", "200");
            slowIter.addOption("seekSleepTime", "200");
            connector.tableOperations().attachIterator(tablename, slowIter, EnumSet.of(IteratorUtil.IteratorScope.scan));
        }
        catch (AccumuloException ex) {
            throw new IllegalStateException("Initialization failed. Could not attach slow iterator", ex);
        }
        catch (TableNotFoundException ex) {
            throw new IllegalStateException("Initialization failed. Could not attach slow iterator", ex);
        }
        catch (AccumuloSecurityException ex) {
            throw new IllegalStateException("Initialization failed. Could not attach slow iterator", ex);
        }
    }

    private static class ScannerThread
    implements Runnable {
        private final Connector connector;
        private Scanner scanner = null;
        private final int workerIndex;
        private final String tablename;
        private final CountDownLatch latch;

        public ScannerThread(Connector connector, int workerIndex, String tablename, CountDownLatch latch) {
            this.connector = connector;
            this.workerIndex = workerIndex;
            this.tablename = tablename;
            this.latch = latch;
        }

        @Override
        public void run() {
            this.latch.countDown();
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                log.error("Thread interrupted with id {}", (Object)this.workerIndex);
                Thread.currentThread().interrupt();
                return;
            }
            log.debug("Creating scanner in worker thread {}", (Object)this.workerIndex);
            try {
                this.scanner = this.connector.createScanner(this.tablename, new Authorizations());
                this.scanner.setReadaheadThreshold(Long.MAX_VALUE);
                this.scanner.setBatchSize(1);
                this.scanner.setRange(new Range(new Text(Integer.toString(this.workerIndex)), new Text("9")));
            }
            catch (TableNotFoundException e) {
                throw new IllegalStateException("Initialization failure. Could not create scanner", e);
            }
            this.scanner.fetchColumnFamily(new Text("fam1"));
            for (Map.Entry entry : this.scanner) {
                if (!testInProgress.get()) {
                    this.scanner.clearScanIterators();
                    this.scanner.close();
                    return;
                }
                Text row = ((Key)entry.getKey()).getRow();
                log.debug("worker {}, row {}", (Object)this.workerIndex, (Object)row.toString());
                if (entry.getValue() != null) {
                    Value prevValue = resultsByWorker.put(this.workerIndex, (Value)entry.getValue());
                    if (prevValue == null) continue;
                    log.trace("worker {} values {}", (Object)this.workerIndex, (Object)String.format("%1$s < %2$s", prevValue, entry.getValue()));
                    Assert.assertTrue((prevValue.compareTo(entry.getValue()) > 0 ? 1 : 0) != 0);
                    continue;
                }
                log.info("Scanner returned null");
                Assert.fail((String)"Scanner returned unexpected null value");
            }
            log.debug("Scanner ran out of data. (info only, not an error) ");
        }
    }
}

