/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.AdminUtil;
import org.apache.accumulo.fate.ReadOnlyTStore;
import org.apache.accumulo.fate.ZooStore;
import org.apache.accumulo.fate.zookeeper.IZooReader;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.server.zookeeper.ZooReaderWriterFactory;
import org.apache.accumulo.test.util.SlowOps;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FateConcurrencyIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(FateConcurrencyIT.class);
    private static final int NUM_ROWS = 1000;
    private static final long SLOW_SCAN_SLEEP_MS = 250L;
    private Connector connector;
    private static final ExecutorService pool = Executors.newCachedThreadPool();
    private String tableName;
    private String secret;
    private long maxWait;
    private SlowOps slowOps;

    @Before
    public void setup() {
        this.connector = this.getConnector();
        this.tableName = this.getUniqueNames(1)[0];
        this.secret = cluster.getSiteConfiguration().get(Property.INSTANCE_SECRET);
        this.maxWait = this.defaultTimeoutSeconds() <= 0 ? 60000L : (long)(this.defaultTimeoutSeconds() * 1000 / 2);
        this.slowOps = new SlowOps(this.connector, this.tableName, this.maxWait, 1);
    }

    @AfterClass
    public static void cleanup() {
        pool.shutdownNow();
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Test
    public void changeTableStateTest() throws Exception {
        Assert.assertEquals((String)"verify table online after created", (Object)TableState.ONLINE, (Object)this.getTableState(this.tableName));
        OnLineCallable onlineOp = new OnLineCallable(this.tableName);
        Future<OnlineOpTiming> task = pool.submit(onlineOp);
        OnlineOpTiming timing1 = task.get();
        log.trace("Online 1 in {} ms", (Object)TimeUnit.MILLISECONDS.convert(timing1.runningTime(), TimeUnit.NANOSECONDS));
        Assert.assertEquals((String)"verify table is still online", (Object)TableState.ONLINE, (Object)this.getTableState(this.tableName));
        this.connector.tableOperations().offline(this.tableName, true);
        Assert.assertEquals((String)"verify table is offline", (Object)TableState.OFFLINE, (Object)this.getTableState(this.tableName));
        onlineOp = new OnLineCallable(this.tableName);
        task = pool.submit(onlineOp);
        OnlineOpTiming timing2 = task.get();
        log.trace("Online 2 in {} ms", (Object)TimeUnit.MILLISECONDS.convert(timing2.runningTime(), TimeUnit.NANOSECONDS));
        Assert.assertEquals((String)"verify table is back online", (Object)TableState.ONLINE, (Object)this.getTableState(this.tableName));
        this.slowOps.startCompactTask();
        onlineOp = new OnLineCallable(this.tableName);
        task = pool.submit(onlineOp);
        OnlineOpTiming timing3 = task.get();
        Assert.assertTrue((String)"online should take less time than expected compaction time", (timing3.runningTime() < TimeUnit.NANOSECONDS.convert(250000L, TimeUnit.MILLISECONDS) ? 1 : 0) != 0);
        Assert.assertEquals((String)"verify table is still online", (Object)TableState.ONLINE, (Object)this.getTableState(this.tableName));
        Assert.assertTrue((String)"Find FATE operation for table", (boolean)this.findFate(this.tableName));
        this.connector.tableOperations().cancelCompaction(this.tableName);
        log.debug("Success: Timing results for online commands.");
        log.debug("Time for unblocked online {} ms", (Object)TimeUnit.MILLISECONDS.convert(timing1.runningTime(), TimeUnit.NANOSECONDS));
        log.debug("Time for online when offline {} ms", (Object)TimeUnit.MILLISECONDS.convert(timing2.runningTime(), TimeUnit.NANOSECONDS));
        log.debug("Time for blocked online {} ms", (Object)TimeUnit.MILLISECONDS.convert(timing3.runningTime(), TimeUnit.NANOSECONDS));
        this.slowOps.blockWhileCompactionRunning();
    }

    private boolean findFate(String aTableName) {
        for (int retry = 0; retry < 5; ++retry) {
            try {
                boolean found = this.lookupFateInZookeeper(aTableName);
                log.trace("Try {}: Fate in zk for table {} : {}", new Object[]{retry, aTableName, found});
                if (found) {
                    log.trace("found for {}", (Object)aTableName);
                    return true;
                }
                Thread.sleep(150L);
                continue;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return false;
            }
            catch (Exception ex) {
                log.debug("Find fate failed for table name {} with exception, will retry", (Object)aTableName, (Object)ex);
            }
        }
        return false;
    }

    @Test
    public void getFateStatus() {
        String tableId;
        Instance instance = this.connector.getInstance();
        try {
            Assert.assertEquals((String)"verify table online after created", (Object)TableState.ONLINE, (Object)this.getTableState(this.tableName));
            tableId = Tables.getTableId((Instance)instance, (String)this.tableName);
            log.trace("tid: {}", (Object)tableId);
        }
        catch (TableNotFoundException ex) {
            throw new IllegalStateException(String.format("Table %s does not exist, failing test", this.tableName));
        }
        this.slowOps.startCompactTask();
        AdminUtil.FateStatus withLocks = null;
        List noLocks = null;
        AdminUtil admin = new AdminUtil(false);
        for (int maxRetries = 3; maxRetries > 0; --maxRetries) {
            try {
                IZooReaderWriter zk = new ZooReaderWriterFactory().getZooReaderWriter(instance.getZooKeepers(), instance.getZooKeepersSessionTimeOut(), this.secret);
                ZooStore zs = new ZooStore(ZooUtil.getRoot((Instance)instance) + "/fate", zk);
                withLocks = admin.getStatus((ReadOnlyTStore)zs, (IZooReader)zk, ZooUtil.getRoot((Instance)instance) + "/table_locks" + "/" + tableId, null, null);
                noLocks = admin.getTransactionStatus((ReadOnlyTStore)zs, null, null);
                break;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                Assert.fail((String)"Interrupt received - test failed");
                return;
            }
            catch (KeeperException ex) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException intr_ex) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
        Assert.assertNotNull(withLocks);
        Assert.assertNotNull(noLocks);
        Assert.assertEquals((long)withLocks.getTransactions().size(), (long)noLocks.size());
        int matchCount = 0;
        for (AdminUtil.TransactionStatus tx : withLocks.getTransactions()) {
            if (!this.isCompaction(tx)) continue;
            log.trace("Fate id: {}, status: {}", (Object)tx.getTxid(), (Object)tx.getStatus());
            for (AdminUtil.TransactionStatus tx2 : noLocks) {
                if (!tx2.getTxid().equals(tx.getTxid())) continue;
                ++matchCount;
            }
        }
        Assert.assertTrue((String)"Number of fates matches should be > 0", (matchCount > 0 ? 1 : 0) != 0);
        try {
            this.connector.tableOperations().cancelCompaction(this.tableName);
            boolean cancelled = this.slowOps.blockWhileCompactionRunning();
            log.debug("Cancel completed successfully: {}", (Object)cancelled);
        }
        catch (AccumuloException | AccumuloSecurityException | TableNotFoundException ex) {
            log.debug("Could not cancel compaction due to exception", ex);
        }
    }

    private boolean lookupFateInZookeeper(String tableName) throws KeeperException {
        Instance instance = this.connector.getInstance();
        AdminUtil admin = new AdminUtil(false);
        try {
            String tableId = Tables.getTableId((Instance)instance, (String)tableName);
            log.trace("tid: {}", (Object)tableId);
            IZooReaderWriter zk = new ZooReaderWriterFactory().getZooReaderWriter(instance.getZooKeepers(), instance.getZooKeepersSessionTimeOut(), this.secret);
            ZooStore zs = new ZooStore(ZooUtil.getRoot((Instance)instance) + "/fate", zk);
            AdminUtil.FateStatus fateStatus = admin.getStatus((ReadOnlyTStore)zs, (IZooReader)zk, ZooUtil.getRoot((Instance)instance) + "/table_locks" + "/" + tableId, null, null);
            log.trace("current fates: {}", (Object)fateStatus.getTransactions().size());
            for (AdminUtil.TransactionStatus tx : fateStatus.getTransactions()) {
                if (!this.isCompaction(tx)) continue;
                return true;
            }
        }
        catch (InterruptedException | TableNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
        return Boolean.FALSE;
    }

    private boolean isCompaction(AdminUtil.TransactionStatus tx) {
        if (tx == null) {
            log.trace("Fate tx is null");
            return false;
        }
        log.trace("Fate id: {}, status: {}", (Object)tx.getTxid(), (Object)tx.getStatus());
        String top = tx.getTop();
        String debug = tx.getDebug();
        return top != null && debug != null && top.contains("CompactionDriver") && tx.getDebug().contains("CompactRange");
    }

    private TableState getTableState(String tableName) throws TableNotFoundException {
        String tableId = Tables.getTableId((Instance)this.connector.getInstance(), (String)tableName);
        TableState tstate = Tables.getTableState((Instance)this.connector.getInstance(), (String)tableId);
        log.trace("tableName: '{}': tableId {}, current state: {}", new Object[]{tableName, tableId, tstate});
        return tstate;
    }

    @Test
    public void multipleCompactions() {
        int tableCount = 4;
        ArrayList<SlowOps> tables = new ArrayList<SlowOps>();
        for (int i = 0; i < tableCount; ++i) {
            String uniqueName = this.getUniqueNames(1)[0] + "_" + i;
            SlowOps gen = new SlowOps(this.connector, uniqueName, this.maxWait, tableCount);
            tables.add(gen);
            gen.startCompactTask();
        }
        int foundCount = 0;
        for (SlowOps t : tables) {
            log.debug("Look for fate {}", (Object)t.getTableName());
            if (!this.findFate(t.getTableName())) continue;
            log.debug("Found fate {}", (Object)t.getTableName());
            ++foundCount;
        }
        Assert.assertEquals((long)tableCount, (long)foundCount);
        for (SlowOps t : tables) {
            try {
                this.connector.tableOperations().cancelCompaction(t.getTableName());
                boolean cancelled = t.blockWhileCompactionRunning();
                if (cancelled) continue;
                log.info("Failed to cancel compaction during multiple compaction test clean-up for {}", (Object)t.getTableName());
            }
            catch (AccumuloException | AccumuloSecurityException | TableNotFoundException ex) {
                log.debug("Exception throw during multiple table test clean-up", ex);
            }
        }
    }

    private class OnLineCallable
    implements Callable<OnlineOpTiming> {
        final String tableName;

        OnLineCallable(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public OnlineOpTiming call() throws Exception {
            OnlineOpTiming status = new OnlineOpTiming();
            log.trace("Setting {} online", (Object)this.tableName);
            FateConcurrencyIT.this.connector.tableOperations().online(this.tableName, true);
            status.setComplete();
            log.trace("Online completed in {} ms", (Object)TimeUnit.MILLISECONDS.convert(status.runningTime(), TimeUnit.NANOSECONDS));
            return status;
        }
    }

    private static class OnlineOpTiming {
        private final long started = System.nanoTime();
        private long completed = 0L;

        OnlineOpTiming() {
        }

        void setComplete() {
            this.completed = System.nanoTime();
        }

        long runningTime() {
            return this.completed - this.started;
        }
    }
}

