/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrentDeleteTableIT
extends AccumuloClusterHarness {
    @Test
    public void testConcurrentDeleteTablesOps() throws Exception {
        final Connector c = this.getConnector();
        String[] tables = this.getUniqueNames(2);
        TreeSet<Text> splits = this.createSplits();
        ExecutorService es = Executors.newFixedThreadPool(20);
        int count = 0;
        for (final String table : tables) {
            c.tableOperations().create(table);
            c.tableOperations().addSplits(table, splits);
            this.writeData(c, table);
            if (count == 1) {
                c.tableOperations().flush(table, null, null, true);
            }
            ++count;
            int numDeleteOps = 20;
            final CountDownLatch cdl = new CountDownLatch(numDeleteOps);
            ArrayList<Future> futures = new ArrayList<Future>();
            for (int i = 0; i < numDeleteOps; ++i) {
                Future future = es.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            cdl.countDown();
                            cdl.await();
                            c.tableOperations().delete(table);
                        }
                        catch (TableNotFoundException tableNotFoundException) {
                        }
                        catch (InterruptedException | AccumuloException | AccumuloSecurityException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                futures.add(future);
            }
            for (Future future : futures) {
                future.get();
            }
            try {
                c.createScanner(table, Authorizations.EMPTY);
                Assert.fail((String)("Expected table " + table + " to be gone."));
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            FunctionalTestUtils.assertNoDanglingFateLocks(this.getConnector().getInstance(), ConcurrentDeleteTableIT.getCluster());
        }
        es.shutdown();
    }

    private TreeSet<Text> createSplits() {
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 0; i < 1000; ++i) {
            Text split = new Text(String.format("%09x", i * 100000));
            splits.add(split);
        }
        return splits;
    }

    @Test
    public void testConcurrentFateOpsWithDelete() throws Exception {
        final Connector c = this.getConnector();
        String[] tables = this.getUniqueNames(2);
        TreeSet<Text> splits = this.createSplits();
        int numOperations = 8;
        ExecutorService es = Executors.newFixedThreadPool(numOperations);
        int count = 0;
        for (final String table : tables) {
            c.tableOperations().create(table);
            c.tableOperations().addSplits(table, splits);
            this.writeData(c, table);
            if (count == 1) {
                c.tableOperations().flush(table, null, null, true);
            }
            ++count;
            final CountDownLatch cdl = new CountDownLatch(numOperations);
            ArrayList futures = new ArrayList();
            futures.add(es.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        cdl.countDown();
                        cdl.await();
                        c.tableOperations().delete(table);
                    }
                    catch (TableNotFoundException | TableOfflineException throwable) {
                    }
                    catch (InterruptedException | AccumuloException | AccumuloSecurityException e) {
                        throw new RuntimeException(e);
                    }
                }
            }));
            futures.add(es.submit(new DelayedTableOp(cdl){

                @Override
                protected void doTableOp() throws Exception {
                    c.tableOperations().compact(table, new CompactionConfig());
                }
            }));
            futures.add(es.submit(new DelayedTableOp(cdl){

                @Override
                protected void doTableOp() throws Exception {
                    c.tableOperations().merge(table, null, null);
                }
            }));
            futures.add(es.submit(new DelayedTableOp(cdl){

                @Override
                protected void doTableOp() throws Exception {
                    Map m = Collections.emptyMap();
                    Set s = Collections.emptySet();
                    c.tableOperations().clone(table, table + "_clone", true, m, s);
                }
            }));
            futures.add(es.submit(new DelayedTableOp(cdl){

                @Override
                protected void doTableOp() throws Exception {
                    c.tableOperations().deleteRows(table, null, null);
                }
            }));
            futures.add(es.submit(new DelayedTableOp(cdl){

                @Override
                protected void doTableOp() throws Exception {
                    c.tableOperations().cancelCompaction(table);
                }
            }));
            futures.add(es.submit(new DelayedTableOp(cdl){

                @Override
                protected void doTableOp() throws Exception {
                    c.tableOperations().rename(table, table + "_renamed");
                }
            }));
            futures.add(es.submit(new DelayedTableOp(cdl){

                @Override
                protected void doTableOp() throws Exception {
                    c.tableOperations().offline(table);
                }
            }));
            Assert.assertEquals((long)numOperations, (long)futures.size());
            for (Future future : futures) {
                future.get();
            }
            try {
                c.createScanner(table, Authorizations.EMPTY);
                Assert.fail((String)("Expected table " + table + " to be gone."));
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            FunctionalTestUtils.assertNoDanglingFateLocks(this.getConnector().getInstance(), ConcurrentDeleteTableIT.getCluster());
        }
        es.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(Connector c, String table) throws TableNotFoundException, MutationsRejectedException {
        try (BatchWriter bw = c.createBatchWriter(table, new BatchWriterConfig());){
            Random rand = new Random();
            for (int i = 0; i < 1000; ++i) {
                Mutation m = new Mutation((CharSequence)String.format("%09x", rand.nextInt(100000000)));
                m.put((CharSequence)"m", (CharSequence)"order", (CharSequence)("" + i));
                bw.addMutation(m);
            }
        }
    }

    private static abstract class DelayedTableOp
    implements Runnable {
        private CountDownLatch cdl;

        DelayedTableOp(CountDownLatch cdl) {
            this.cdl = cdl;
        }

        @Override
        public void run() {
            try {
                this.cdl.countDown();
                this.cdl.await();
                Thread.sleep(10L);
                this.doTableOp();
            }
            catch (TableNotFoundException | TableOfflineException throwable) {
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract void doTableOp() throws Exception;
    }
}

