/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.examples.simple.filedata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyValue;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.accumulo.examples.simple.filedata.ChunkInputStream;
import org.apache.accumulo.examples.simple.filedata.FileDataIngest;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChunkInputStreamIT
extends AccumuloClusterHarness {
    private static final Authorizations AUTHS = new Authorizations(new String[]{"A", "B", "C", "D"});
    private Connector conn;
    private String tableName;
    private List<Map.Entry<Key, Value>> data;
    private List<Map.Entry<Key, Value>> baddata;
    private List<Map.Entry<Key, Value>> multidata;

    @Before
    public void setupInstance() throws Exception {
        this.conn = this.getConnector();
        this.tableName = this.getUniqueNames(1)[0];
        this.conn.securityOperations().changeUserAuthorizations(this.conn.whoami(), AUTHS);
    }

    @Before
    public void setupData() {
        this.data = new ArrayList<Map.Entry<Key, Value>>();
        ChunkInputStreamIT.addData(this.data, "a", "refs", "id\u0000ext", "A&B", "ext");
        ChunkInputStreamIT.addData(this.data, "a", "refs", "id\u0000name", "A&B", "name");
        ChunkInputStreamIT.addData(this.data, "a", "~chunk", 100, 0, "A&B", "asdfjkl;");
        ChunkInputStreamIT.addData(this.data, "a", "~chunk", 100, 1, "A&B", "");
        ChunkInputStreamIT.addData(this.data, "b", "refs", "id\u0000ext", "A&B", "ext");
        ChunkInputStreamIT.addData(this.data, "b", "refs", "id\u0000name", "A&B", "name");
        ChunkInputStreamIT.addData(this.data, "b", "~chunk", 100, 0, "A&B", "qwertyuiop");
        ChunkInputStreamIT.addData(this.data, "b", "~chunk", 100, 0, "B&C", "qwertyuiop");
        ChunkInputStreamIT.addData(this.data, "b", "~chunk", 100, 1, "A&B", "");
        ChunkInputStreamIT.addData(this.data, "b", "~chunk", 100, 1, "B&C", "");
        ChunkInputStreamIT.addData(this.data, "b", "~chunk", 100, 1, "D", "");
        ChunkInputStreamIT.addData(this.data, "c", "~chunk", 100, 0, "A&B", "asdfjkl;");
        ChunkInputStreamIT.addData(this.data, "c", "~chunk", 100, 1, "A&B", "asdfjkl;");
        ChunkInputStreamIT.addData(this.data, "c", "~chunk", 100, 2, "A&B", "");
        ChunkInputStreamIT.addData(this.data, "d", "~chunk", 100, 0, "A&B", "");
        ChunkInputStreamIT.addData(this.data, "e", "~chunk", 100, 0, "A&B", "asdfjkl;");
        ChunkInputStreamIT.addData(this.data, "e", "~chunk", 100, 1, "A&B", "");
        this.baddata = new ArrayList<Map.Entry<Key, Value>>();
        ChunkInputStreamIT.addData(this.baddata, "a", "~chunk", 100, 0, "A", "asdfjkl;");
        ChunkInputStreamIT.addData(this.baddata, "b", "~chunk", 100, 0, "B", "asdfjkl;");
        ChunkInputStreamIT.addData(this.baddata, "b", "~chunk", 100, 2, "C", "");
        ChunkInputStreamIT.addData(this.baddata, "c", "~chunk", 100, 0, "D", "asdfjkl;");
        ChunkInputStreamIT.addData(this.baddata, "c", "~chunk", 100, 2, "E", "");
        ChunkInputStreamIT.addData(this.baddata, "d", "~chunk", 100, 0, "F", "asdfjkl;");
        ChunkInputStreamIT.addData(this.baddata, "d", "~chunk", 100, 1, "G", "");
        ChunkInputStreamIT.addData(this.baddata, "d", "~zzzzz", "colq", "H", "");
        ChunkInputStreamIT.addData(this.baddata, "e", "~chunk", 100, 0, "I", "asdfjkl;");
        ChunkInputStreamIT.addData(this.baddata, "e", "~chunk", 100, 1, "J", "");
        ChunkInputStreamIT.addData(this.baddata, "e", "~chunk", 100, 2, "I", "asdfjkl;");
        ChunkInputStreamIT.addData(this.baddata, "f", "~chunk", 100, 2, "K", "asdfjkl;");
        ChunkInputStreamIT.addData(this.baddata, "g", "~chunk", 100, 0, "L", "");
        this.multidata = new ArrayList<Map.Entry<Key, Value>>();
        ChunkInputStreamIT.addData(this.multidata, "a", "~chunk", 100, 0, "A&B", "asdfjkl;");
        ChunkInputStreamIT.addData(this.multidata, "a", "~chunk", 100, 1, "A&B", "");
        ChunkInputStreamIT.addData(this.multidata, "a", "~chunk", 200, 0, "B&C", "asdfjkl;");
        ChunkInputStreamIT.addData(this.multidata, "b", "~chunk", 100, 0, "A&B", "asdfjkl;");
        ChunkInputStreamIT.addData(this.multidata, "b", "~chunk", 200, 0, "B&C", "asdfjkl;");
        ChunkInputStreamIT.addData(this.multidata, "b", "~chunk", 200, 1, "B&C", "asdfjkl;");
        ChunkInputStreamIT.addData(this.multidata, "c", "~chunk", 100, 0, "A&B", "asdfjkl;");
        ChunkInputStreamIT.addData(this.multidata, "c", "~chunk", 100, 1, "B&C", "");
    }

    static void addData(List<Map.Entry<Key, Value>> data, String row, String cf, String cq, String vis, String value) {
        data.add((Map.Entry<Key, Value>)new KeyValue(new Key(new Text(row), new Text(cf), new Text(cq), new Text(vis)), value.getBytes()));
    }

    static void addData(List<Map.Entry<Key, Value>> data, String row, String cf, int chunkSize, int chunkCount, String vis, String value) {
        Text chunkCQ = new Text(FileDataIngest.intToBytes((int)chunkSize));
        chunkCQ.append(FileDataIngest.intToBytes((int)chunkCount), 0, 4);
        data.add((Map.Entry<Key, Value>)new KeyValue(new Key(new Text(row), new Text(cf), chunkCQ, new Text(vis)), value.getBytes()));
    }

    @Test
    public void testWithAccumulo() throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException, IOException {
        this.conn.tableOperations().create(this.tableName);
        BatchWriter bw = this.conn.createBatchWriter(this.tableName, new BatchWriterConfig());
        for (Map.Entry<Key, Value> e : this.data) {
            Key k = e.getKey();
            Mutation m = new Mutation(k.getRow());
            m.put(k.getColumnFamily(), k.getColumnQualifier(), new ColumnVisibility(k.getColumnVisibility()), e.getValue());
            bw.addMutation(m);
        }
        bw.close();
        Scanner scan = this.conn.createScanner(this.tableName, AUTHS);
        ChunkInputStream cis = new ChunkInputStream();
        byte[] b = new byte[20];
        PeekingIterator pi = new PeekingIterator(scan.iterator());
        cis.setSource(pi);
        int read = cis.read(b);
        Assert.assertEquals((long)read, (long)8L);
        Assert.assertEquals((Object)new String(b, 0, read), (Object)"asdfjkl;");
        read = cis.read(b);
        Assert.assertEquals((long)read, (long)-1L);
        cis.setSource(pi);
        read = cis.read(b);
        Assert.assertEquals((long)read, (long)10L);
        Assert.assertEquals((Object)new String(b, 0, read), (Object)"qwertyuiop");
        read = cis.read(b);
        Assert.assertEquals((long)read, (long)-1L);
        Assert.assertEquals((Object)cis.getVisibilities().toString(), (Object)"[A&B, B&C, D]");
        cis.close();
        cis.setSource(pi);
        read = cis.read(b);
        Assert.assertEquals((long)read, (long)16L);
        Assert.assertEquals((Object)new String(b, 0, read), (Object)"asdfjkl;asdfjkl;");
        read = cis.read(b);
        Assert.assertEquals((long)read, (long)-1L);
        Assert.assertEquals((Object)cis.getVisibilities().toString(), (Object)"[A&B]");
        cis.close();
        cis.setSource(pi);
        read = cis.read(b);
        Assert.assertEquals((long)read, (long)-1L);
        cis.close();
        cis.setSource(pi);
        read = cis.read(b);
        Assert.assertEquals((long)read, (long)8L);
        Assert.assertEquals((Object)new String(b, 0, read), (Object)"asdfjkl;");
        read = cis.read(b);
        Assert.assertEquals((long)read, (long)-1L);
        cis.close();
        Assert.assertFalse((boolean)pi.hasNext());
    }
}

