/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterables;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingWalHeaderCompletesRecoveryIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(MissingWalHeaderCompletesRecoveryIT.class);
    private boolean rootHasWritePermission;

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration conf) {
        cfg.setNumTservers(1);
        cfg.setProperty(Property.MASTER_RECOVERY_DELAY, "1s");
        cfg.setProperty(Property.GC_CYCLE_START, "999999s");
        conf.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Before
    public void setupMetadataPermission() throws Exception {
        Connector conn = this.getConnector();
        this.rootHasWritePermission = conn.securityOperations().hasTablePermission("root", "accumulo.metadata", TablePermission.WRITE);
        if (!this.rootHasWritePermission) {
            conn.securityOperations().grantTablePermission("root", "accumulo.metadata", TablePermission.WRITE);
            Thread.sleep(5000L);
        }
    }

    @After
    public void resetMetadataPermission() throws Exception {
        Connector conn = this.getConnector();
        if (this.rootHasWritePermission != conn.securityOperations().hasTablePermission("root", "accumulo.metadata", TablePermission.WRITE)) {
            if (this.rootHasWritePermission) {
                conn.securityOperations().grantTablePermission("root", "accumulo.metadata", TablePermission.WRITE);
            } else {
                conn.securityOperations().revokeTablePermission("root", "accumulo.metadata", TablePermission.WRITE);
            }
        }
    }

    @Test
    public void testEmptyWalRecoveryCompletes() throws Exception {
        Connector conn = this.getConnector();
        MiniAccumuloClusterImpl cluster = this.getCluster();
        FileSystem fs = cluster.getFileSystem();
        String fakeServer = "127.0.0.1:12345";
        File walogs = new File(cluster.getConfig().getAccumuloDir(), "wal");
        File walogServerDir = new File(walogs, fakeServer.replace(':', '+'));
        File emptyWalog = new File(walogServerDir, UUID.randomUUID().toString());
        log.info("Created empty WAL at " + emptyWalog.toURI());
        fs.create(new Path(emptyWalog.toURI())).close();
        Assert.assertTrue((String)"root user did not have write permission to metadata table", (boolean)conn.securityOperations().hasTablePermission("root", "accumulo.metadata", TablePermission.WRITE));
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        String tableId = (String)conn.tableOperations().tableIdMap().get(tableName);
        Assert.assertNotNull((String)"Table ID was null", (Object)tableId);
        LogEntry logEntry = new LogEntry(new KeyExtent(tableId, null, null), 0L, "127.0.0.1:12345", emptyWalog.toURI().toString());
        log.info("Taking {} offline", (Object)tableName);
        conn.tableOperations().offline(tableName, true);
        log.info("{} is offline", (Object)tableName);
        Text row = MetadataSchema.TabletsSection.getRow((String)tableId, null);
        Mutation m = new Mutation(row);
        m.put(logEntry.getColumnFamily(), logEntry.getColumnQualifier(), logEntry.getValue());
        BatchWriter bw = conn.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
        bw.addMutation(m);
        bw.close();
        log.info("Bringing {} online", (Object)tableName);
        conn.tableOperations().online(tableName, true);
        log.info("{} is online", (Object)tableName);
        Scanner s = conn.createScanner(tableName, Authorizations.EMPTY);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)s));
    }

    @Test
    public void testPartialHeaderWalRecoveryCompletes() throws Exception {
        Connector conn = this.getConnector();
        MiniAccumuloClusterImpl cluster = this.getCluster();
        FileSystem fs = this.getCluster().getFileSystem();
        String fakeServer = "127.0.0.1:12345";
        File walogs = new File(cluster.getConfig().getAccumuloDir(), "wal");
        File walogServerDir = new File(walogs, fakeServer.replace(':', '+'));
        File partialHeaderWalog = new File(walogServerDir, UUID.randomUUID().toString());
        log.info("Created WAL with malformed header at " + partialHeaderWalog.toURI());
        FSDataOutputStream wal = fs.create(new Path(partialHeaderWalog.toURI()));
        wal.write("--- Log File Header (v3) ---".getBytes(StandardCharsets.UTF_8), 0, "--- Log File Header (v3) ---".length() / 2);
        wal.close();
        Assert.assertTrue((String)"root user did not have write permission to metadata table", (boolean)conn.securityOperations().hasTablePermission("root", "accumulo.metadata", TablePermission.WRITE));
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        String tableId = (String)conn.tableOperations().tableIdMap().get(tableName);
        Assert.assertNotNull((String)"Table ID was null", (Object)tableId);
        LogEntry logEntry = new LogEntry(null, 0L, "127.0.0.1:12345", partialHeaderWalog.toURI().toString());
        log.info("Taking {} offline", (Object)tableName);
        conn.tableOperations().offline(tableName, true);
        log.info("{} is offline", (Object)tableName);
        Text row = MetadataSchema.TabletsSection.getRow((String)tableId, null);
        Mutation m = new Mutation(row);
        m.put(logEntry.getColumnFamily(), logEntry.getColumnQualifier(), logEntry.getValue());
        BatchWriter bw = conn.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
        bw.addMutation(m);
        bw.close();
        log.info("Bringing {} online", (Object)tableName);
        conn.tableOperations().online(tableName, true);
        log.info("{} is online", (Object)tableName);
        Scanner s = conn.createScanner(tableName, Authorizations.EMPTY);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)s));
    }
}

