/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.minicluster.impl;

import com.google.common.collect.Maps;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.accumulo.cluster.ClusterControl;
import org.apache.accumulo.gc.SimpleGarbageCollector;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.ProcessNotFoundException;
import org.apache.accumulo.minicluster.impl.ProcessReference;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.tracer.TraceServer;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniAccumuloClusterControl
implements ClusterControl {
    private static final Logger log = LoggerFactory.getLogger(MiniAccumuloClusterControl.class);
    protected MiniAccumuloClusterImpl cluster;
    Process zooKeeperProcess = null;
    Process masterProcess = null;
    Process gcProcess = null;
    Process monitor = null;
    Process tracer = null;
    final List<Process> tabletServerProcesses = new ArrayList<Process>();

    public MiniAccumuloClusterControl(MiniAccumuloClusterImpl cluster) {
        Objects.requireNonNull(cluster);
        this.cluster = cluster;
    }

    public void start(ServerType server) throws IOException {
        this.start(server, null);
    }

    @Override
    public int exec(Class<?> clz, String[] args) throws IOException {
        int exitCode;
        Process p = this.cluster.exec(clz, args);
        try {
            exitCode = p.waitFor();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted waiting for process to exit", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        return exitCode;
    }

    @Override
    public Map.Entry<Integer, String> execWithStdout(Class<?> clz, String[] args) throws IOException {
        int exitCode;
        Process p = this.cluster.exec(clz, args);
        try {
            exitCode = p.waitFor();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted waiting for process to exit", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        for (MiniAccumuloClusterImpl.LogWriter writer : this.cluster.getLogWriters()) {
            writer.flush();
        }
        return Maps.immutableEntry((Object)exitCode, (Object)this.readAll(new FileInputStream(this.cluster.getConfig().getLogDir() + "/" + clz.getSimpleName() + "_" + p.hashCode() + ".out")));
    }

    private String readAll(InputStream is) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        StringBuilder result = new StringBuilder();
        while ((n = is.read(buffer)) > 0) {
            result.append(new String(buffer, 0, n));
        }
        return result.toString();
    }

    @Override
    public void adminStopAll() throws IOException {
        Process p = this.cluster.exec(Admin.class, "stopAll");
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        if (0 != p.exitValue()) {
            throw new IOException("Failed to run `accumulo admin stopAll`");
        }
    }

    @Override
    public synchronized void startAllServers(ServerType server) throws IOException {
        this.start(server, null);
    }

    @Override
    public synchronized void start(ServerType server, String hostname) throws IOException {
        this.start(server, hostname, Collections.emptyMap(), Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(ServerType server, String hostname, Map<String, String> configOverrides, int limit) throws IOException {
        if (limit <= 0) {
            return;
        }
        switch (server) {
            case TABLET_SERVER: {
                List<Process> list = this.tabletServerProcesses;
                synchronized (list) {
                    int count = 0;
                    for (int i = this.tabletServerProcesses.size(); count < limit && i < this.cluster.getConfig().getNumTservers(); ++i, ++count) {
                        this.tabletServerProcesses.add(this.cluster._exec(TabletServer.class, server, configOverrides, new String[0]));
                    }
                    break;
                }
            }
            case MASTER: {
                if (null != this.masterProcess) break;
                this.masterProcess = this.cluster._exec(Master.class, server, configOverrides, new String[0]);
                break;
            }
            case ZOOKEEPER: {
                if (null != this.zooKeeperProcess) break;
                this.zooKeeperProcess = this.cluster._exec(ZooKeeperServerMain.class, server, configOverrides, this.cluster.getZooCfgFile().getAbsolutePath());
                break;
            }
            case GARBAGE_COLLECTOR: {
                if (null != this.gcProcess) break;
                this.gcProcess = this.cluster._exec(SimpleGarbageCollector.class, server, configOverrides, new String[0]);
                break;
            }
            case MONITOR: {
                if (null != this.monitor) break;
                this.monitor = this.cluster._exec(Monitor.class, server, configOverrides, new String[0]);
                break;
            }
            case TRACER: {
                if (null != this.tracer) break;
                this.tracer = this.cluster._exec(TraceServer.class, server, configOverrides, new String[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot start process for " + (Object)((Object)server));
            }
        }
    }

    @Override
    public synchronized void stopAllServers(ServerType server) throws IOException {
        this.stop(server);
    }

    public void stop(ServerType server) throws IOException {
        this.stop(server, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop(ServerType server, String hostname) throws IOException {
        switch (server) {
            case MASTER: {
                if (null == this.masterProcess) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.masterProcess, 30L, TimeUnit.SECONDS);
                    break;
                }
                catch (ExecutionException e) {
                    log.warn("Master did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (TimeoutException e) {
                    log.warn("Master did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                finally {
                    this.masterProcess = null;
                }
            }
            case GARBAGE_COLLECTOR: {
                if (null == this.gcProcess) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.gcProcess, 30L, TimeUnit.SECONDS);
                    break;
                }
                catch (ExecutionException e) {
                    log.warn("Garbage collector did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (TimeoutException e) {
                    log.warn("Garbage collector did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                finally {
                    this.gcProcess = null;
                }
            }
            case ZOOKEEPER: {
                if (null == this.zooKeeperProcess) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.zooKeeperProcess, 30L, TimeUnit.SECONDS);
                    break;
                }
                catch (ExecutionException e) {
                    log.warn("ZooKeeper did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (TimeoutException e) {
                    log.warn("ZooKeeper did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                finally {
                    this.zooKeeperProcess = null;
                }
            }
            case TABLET_SERVER: {
                List<Process> e = this.tabletServerProcesses;
                synchronized (e) {
                    try {
                        for (Process tserver : this.tabletServerProcesses) {
                            try {
                                this.cluster.stopProcessWithTimeout(tserver, 30L, TimeUnit.SECONDS);
                            }
                            catch (ExecutionException e2) {
                                log.warn("TabletServer did not fully stop after 30 seconds", (Throwable)e2);
                            }
                            catch (TimeoutException e3) {
                                log.warn("TabletServer did not fully stop after 30 seconds", (Throwable)e3);
                            }
                            catch (InterruptedException e4) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        break;
                    }
                    finally {
                        this.tabletServerProcesses.clear();
                    }
                }
            }
            case MONITOR: {
                if (this.monitor == null) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.monitor, 30L, TimeUnit.SECONDS);
                    break;
                }
                catch (ExecutionException e) {
                    log.warn("Monitor did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (TimeoutException e) {
                    log.warn("Monitor did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                finally {
                    this.monitor = null;
                }
            }
            case TRACER: {
                if (this.tracer == null) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.tracer, 30L, TimeUnit.SECONDS);
                    break;
                }
                catch (ExecutionException e) {
                    log.warn("Tracer did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (TimeoutException e) {
                    log.warn("Tracer did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                finally {
                    this.tracer = null;
                }
            }
            default: {
                throw new UnsupportedOperationException("ServerType is not yet supported " + (Object)((Object)server));
            }
        }
    }

    @Override
    public void signal(ServerType server, String hostname, String signal) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void suspend(ServerType server, String hostname) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resume(ServerType server, String hostname) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killProcess(ServerType type, ProcessReference procRef) throws ProcessNotFoundException, InterruptedException {
        boolean found = false;
        switch (type) {
            case MASTER: {
                if (!procRef.getProcess().equals(this.masterProcess)) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.masterProcess, 30L, TimeUnit.SECONDS);
                }
                catch (ExecutionException e) {
                    log.warn("Master did not fully stop after 30 seconds", (Throwable)e);
                }
                catch (TimeoutException e) {
                    log.warn("Master did not fully stop after 30 seconds", (Throwable)e);
                }
                this.masterProcess = null;
                found = true;
                break;
            }
            case TABLET_SERVER: {
                List<Process> e = this.tabletServerProcesses;
                synchronized (e) {
                    for (Process tserver : this.tabletServerProcesses) {
                        if (!procRef.getProcess().equals(tserver)) continue;
                        this.tabletServerProcesses.remove(tserver);
                        try {
                            this.cluster.stopProcessWithTimeout(tserver, 30L, TimeUnit.SECONDS);
                        }
                        catch (ExecutionException e2) {
                            log.warn("TabletServer did not fully stop after 30 seconds", (Throwable)e2);
                        }
                        catch (TimeoutException e3) {
                            log.warn("TabletServer did not fully stop after 30 seconds", (Throwable)e3);
                        }
                        found = true;
                        break;
                    }
                    break;
                }
            }
            case ZOOKEEPER: {
                if (!procRef.getProcess().equals(this.zooKeeperProcess)) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.zooKeeperProcess, 30L, TimeUnit.SECONDS);
                }
                catch (ExecutionException e) {
                    log.warn("ZooKeeper did not fully stop after 30 seconds", (Throwable)e);
                }
                catch (TimeoutException e) {
                    log.warn("ZooKeeper did not fully stop after 30 seconds", (Throwable)e);
                }
                this.zooKeeperProcess = null;
                found = true;
                break;
            }
            case GARBAGE_COLLECTOR: {
                if (!procRef.getProcess().equals(this.gcProcess)) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.gcProcess, 30L, TimeUnit.SECONDS);
                }
                catch (ExecutionException e) {
                    log.warn("GarbageCollector did not fully stop after 30 seconds", (Throwable)e);
                }
                catch (TimeoutException e) {
                    log.warn("GarbageCollector did not fully stop after 30 seconds", (Throwable)e);
                }
                this.gcProcess = null;
                found = true;
                break;
            }
            default: {
                found = true;
            }
        }
        if (!found) {
            throw new ProcessNotFoundException();
        }
    }

    @Override
    public void kill(ServerType server, String hostname) throws IOException {
        this.stop(server, hostname);
    }
}

