/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import jline.console.ConsoleReader;
import jline.console.UserInterruptException;
import jline.console.completer.Completer;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.TConstraintViolationSummary;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.trace.DistributedTrace;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.core.util.DeprecationUtil;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.accumulo.core.util.format.Formatter;
import org.apache.accumulo.core.util.format.FormatterConfig;
import org.apache.accumulo.core.util.format.FormatterFactory;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.shell.ShellCompletor;
import org.apache.accumulo.shell.ShellOptions;
import org.apache.accumulo.shell.ShellOptionsJC;
import org.apache.accumulo.shell.Token;
import org.apache.accumulo.shell.commands.AboutCommand;
import org.apache.accumulo.shell.commands.AddAuthsCommand;
import org.apache.accumulo.shell.commands.AddSplitsCommand;
import org.apache.accumulo.shell.commands.AuthenticateCommand;
import org.apache.accumulo.shell.commands.ByeCommand;
import org.apache.accumulo.shell.commands.ClasspathCommand;
import org.apache.accumulo.shell.commands.ClearCommand;
import org.apache.accumulo.shell.commands.CloneTableCommand;
import org.apache.accumulo.shell.commands.ClsCommand;
import org.apache.accumulo.shell.commands.CompactCommand;
import org.apache.accumulo.shell.commands.ConfigCommand;
import org.apache.accumulo.shell.commands.ConstraintCommand;
import org.apache.accumulo.shell.commands.CreateNamespaceCommand;
import org.apache.accumulo.shell.commands.CreateTableCommand;
import org.apache.accumulo.shell.commands.CreateUserCommand;
import org.apache.accumulo.shell.commands.DUCommand;
import org.apache.accumulo.shell.commands.DebugCommand;
import org.apache.accumulo.shell.commands.DeleteAuthsCommand;
import org.apache.accumulo.shell.commands.DeleteCommand;
import org.apache.accumulo.shell.commands.DeleteIterCommand;
import org.apache.accumulo.shell.commands.DeleteManyCommand;
import org.apache.accumulo.shell.commands.DeleteNamespaceCommand;
import org.apache.accumulo.shell.commands.DeleteRowsCommand;
import org.apache.accumulo.shell.commands.DeleteScanIterCommand;
import org.apache.accumulo.shell.commands.DeleteShellIterCommand;
import org.apache.accumulo.shell.commands.DeleteTableCommand;
import org.apache.accumulo.shell.commands.DeleteUserCommand;
import org.apache.accumulo.shell.commands.DropTableCommand;
import org.apache.accumulo.shell.commands.DropUserCommand;
import org.apache.accumulo.shell.commands.EGrepCommand;
import org.apache.accumulo.shell.commands.ExecfileCommand;
import org.apache.accumulo.shell.commands.ExitCommand;
import org.apache.accumulo.shell.commands.ExportTableCommand;
import org.apache.accumulo.shell.commands.ExtensionCommand;
import org.apache.accumulo.shell.commands.FateCommand;
import org.apache.accumulo.shell.commands.FlushCommand;
import org.apache.accumulo.shell.commands.FormatterCommand;
import org.apache.accumulo.shell.commands.GetAuthsCommand;
import org.apache.accumulo.shell.commands.GetGroupsCommand;
import org.apache.accumulo.shell.commands.GetSplitsCommand;
import org.apache.accumulo.shell.commands.GrantCommand;
import org.apache.accumulo.shell.commands.GrepCommand;
import org.apache.accumulo.shell.commands.HelpCommand;
import org.apache.accumulo.shell.commands.HiddenCommand;
import org.apache.accumulo.shell.commands.HistoryCommand;
import org.apache.accumulo.shell.commands.ImportDirectoryCommand;
import org.apache.accumulo.shell.commands.ImportTableCommand;
import org.apache.accumulo.shell.commands.InfoCommand;
import org.apache.accumulo.shell.commands.InsertCommand;
import org.apache.accumulo.shell.commands.InterpreterCommand;
import org.apache.accumulo.shell.commands.ListBulkCommand;
import org.apache.accumulo.shell.commands.ListCompactionsCommand;
import org.apache.accumulo.shell.commands.ListIterCommand;
import org.apache.accumulo.shell.commands.ListScansCommand;
import org.apache.accumulo.shell.commands.ListShellIterCommand;
import org.apache.accumulo.shell.commands.MaxRowCommand;
import org.apache.accumulo.shell.commands.MergeCommand;
import org.apache.accumulo.shell.commands.NamespacePermissionsCommand;
import org.apache.accumulo.shell.commands.NamespacesCommand;
import org.apache.accumulo.shell.commands.NoTableCommand;
import org.apache.accumulo.shell.commands.OfflineCommand;
import org.apache.accumulo.shell.commands.OnlineCommand;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.accumulo.shell.commands.PasswdCommand;
import org.apache.accumulo.shell.commands.PingCommand;
import org.apache.accumulo.shell.commands.QuestionCommand;
import org.apache.accumulo.shell.commands.QuitCommand;
import org.apache.accumulo.shell.commands.QuotedStringTokenizer;
import org.apache.accumulo.shell.commands.RenameNamespaceCommand;
import org.apache.accumulo.shell.commands.RenameTableCommand;
import org.apache.accumulo.shell.commands.RevokeCommand;
import org.apache.accumulo.shell.commands.ScanCommand;
import org.apache.accumulo.shell.commands.ScriptCommand;
import org.apache.accumulo.shell.commands.SetAuthsCommand;
import org.apache.accumulo.shell.commands.SetGroupsCommand;
import org.apache.accumulo.shell.commands.SetIterCommand;
import org.apache.accumulo.shell.commands.SetScanIterCommand;
import org.apache.accumulo.shell.commands.SetShellIterCommand;
import org.apache.accumulo.shell.commands.SleepCommand;
import org.apache.accumulo.shell.commands.SystemPermissionsCommand;
import org.apache.accumulo.shell.commands.TableCommand;
import org.apache.accumulo.shell.commands.TablePermissionsCommand;
import org.apache.accumulo.shell.commands.TablesCommand;
import org.apache.accumulo.shell.commands.TraceCommand;
import org.apache.accumulo.shell.commands.UserCommand;
import org.apache.accumulo.shell.commands.UserPermissionsCommand;
import org.apache.accumulo.shell.commands.UsersCommand;
import org.apache.accumulo.shell.commands.WhoAmICommand;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.start.classloader.vfs.ContextManager;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Shell
extends ShellOptions
implements KeywordExecutable {
    public static final Logger log = Logger.getLogger(Shell.class);
    private static final Logger audit = Logger.getLogger((String)(Shell.class.getName() + ".audit"));
    public static final Charset CHARSET = StandardCharsets.ISO_8859_1;
    public static final int NO_FIXED_ARG_LENGTH_CHECK = -1;
    public static final String COMMENT_PREFIX = "#";
    public static final String HISTORY_DIR_NAME = ".accumulo";
    public static final String HISTORY_FILE_NAME = "shell_history.txt";
    private static final String SHELL_DESCRIPTION = "Shell - Apache Accumulo Interactive Shell";
    protected int exitCode = 0;
    private String tableName;
    protected Instance instance;
    private Connector connector;
    protected ConsoleReader reader;
    private AuthenticationToken token;
    private final Class<? extends Formatter> defaultFormatterClass = DefaultFormatter.class;
    public Map<String, List<IteratorSetting>> scanIteratorOptions = new HashMap<String, List<IteratorSetting>>();
    public Map<String, List<IteratorSetting>> iteratorProfiles = new HashMap<String, List<IteratorSetting>>();
    private Token rootToken;
    public final Map<String, Command> commandFactory = new TreeMap<String, Command>();
    public final Map<String, Command[]> commandGrouping = new TreeMap<String, Command[]>();
    private boolean exit = false;
    protected File execFile = null;
    protected String execCommand = null;
    protected boolean verbose = true;
    private boolean tabCompletion;
    private boolean disableAuthTimeout;
    private long authTimeout;
    private long lastUserActivity = System.nanoTime();
    private boolean logErrorsToConsole = false;
    private boolean masking = false;

    public Shell() {
        String prop = "input.encoding";
        if (System.getProperty(prop) == null) {
            String value = System.getProperty("jline.WindowsTerminal.output.encoding");
            if (value == null) {
                value = System.getProperty("file.encoding");
            }
            if (value != null) {
                System.setProperty(prop, value);
            }
        }
    }

    public Shell(ConsoleReader reader) {
        String prop = "input.encoding";
        if (System.getProperty(prop) == null) {
            String value = System.getProperty("jline.WindowsTerminal.output.encoding");
            if (value == null) {
                value = System.getProperty("file.encoding");
            }
            if (value != null) {
                System.setProperty(prop, value);
            }
        }
        this.reader = reader;
    }

    public boolean config(String ... args) throws IOException {
        String user;
        ClientConfiguration clientConf;
        if (this.reader == null) {
            this.reader = new ConsoleReader();
        }
        ShellOptionsJC options = new ShellOptionsJC();
        JCommander jc = new JCommander();
        jc.setProgramName("accumulo shell");
        jc.addObject((Object)options);
        try {
            jc.parse(args);
        }
        catch (ParameterException e) {
            jc.usage();
            this.exitCode = 1;
            return false;
        }
        if (options.isHelpEnabled()) {
            jc.usage();
            this.exitCode = 0;
            return false;
        }
        if (options.getUnrecognizedOptions() != null) {
            this.logError("Unrecognized Options: " + options.getUnrecognizedOptions().toString());
            jc.usage();
            this.exitCode = 1;
            return false;
        }
        Shell.setDebugging(options.isDebugEnabled());
        this.authTimeout = TimeUnit.MINUTES.toNanos(options.getAuthTimeout());
        this.disableAuthTimeout = options.isAuthTimeoutDisabled();
        try {
            clientConf = options.getClientConfiguration();
        }
        catch (Exception e) {
            this.printException(e);
            return true;
        }
        if (Boolean.parseBoolean(clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_RPC_SASL_ENABLED))) {
            log.debug((Object)"SASL is enabled, disabling authorization timeout");
            this.disableAuthTimeout = true;
        }
        try {
            user = options.getUsername();
        }
        catch (Exception e) {
            this.printException(e);
            return true;
        }
        String password = options.getPassword();
        this.tabCompletion = !options.isTabCompletionDisabled();
        this.setInstance(options);
        try {
            this.token = options.getAuthenticationToken();
        }
        catch (Exception e) {
            this.printException(e);
            return true;
        }
        Map<String, String> loginOptions = options.getTokenProperties();
        try {
            boolean hasToken;
            boolean bl = hasToken = this.token != null;
            if (hasToken && password != null) {
                throw new ParameterException("Can not supply '--pass' option with '--tokenClass' option");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Shell.this.reader.getTerminal().setEchoEnabled(true);
                }
            });
            if (hasToken) {
                AuthenticationToken.Properties props = new AuthenticationToken.Properties();
                if (!loginOptions.isEmpty()) {
                    props.putAllStrings(loginOptions);
                }
                this.token.init(props);
            } else {
                if ("stdin".equals(password) || password == null) {
                    password = this.reader.readLine("Password: ", Character.valueOf('*'));
                }
                if (password == null) {
                    throw new ParameterException("No password or token option supplied");
                }
                this.token = new PasswordToken((CharSequence)password);
            }
            if (!options.isFake()) {
                DistributedTrace.enable((String)InetAddress.getLocalHost().getHostName(), (String)"shell", (ClientConfiguration)clientConf);
            }
            this.setTableName("");
            this.connector = this.instance.getConnector(user, this.token);
        }
        catch (Exception e) {
            this.printException(e);
            this.exitCode = 1;
            return false;
        }
        if (options.getExecFile() != null) {
            this.execFile = options.getExecFile();
            this.verbose = false;
        } else if (options.getExecFileVerbose() != null) {
            this.execFile = options.getExecFileVerbose();
            this.verbose = true;
        }
        this.execCommand = options.getExecCommand();
        if (this.execCommand != null) {
            this.verbose = false;
        }
        this.rootToken = new Token();
        Command[] dataCommands = new Command[]{new DeleteCommand(), new DeleteManyCommand(), new DeleteRowsCommand(), new EGrepCommand(), new FormatterCommand(), new InterpreterCommand(), new GrepCommand(), new ImportDirectoryCommand(), new InsertCommand(), new MaxRowCommand(), new ScanCommand()};
        Command[] debuggingCommands = new Command[]{new ClasspathCommand(), new DebugCommand(), new ListScansCommand(), new ListCompactionsCommand(), new TraceCommand(), new PingCommand(), new ListBulkCommand()};
        Command[] execCommands = new Command[]{new ExecfileCommand(), new HistoryCommand(), new ExtensionCommand(), new ScriptCommand()};
        Command[] exitCommands = new Command[]{new ByeCommand(), new ExitCommand(), new QuitCommand()};
        Command[] helpCommands = new Command[]{new AboutCommand(), new HelpCommand(), new InfoCommand(), new QuestionCommand()};
        Command[] iteratorCommands = new Command[]{new DeleteIterCommand(), new DeleteScanIterCommand(), new ListIterCommand(), new SetIterCommand(), new SetScanIterCommand(), new SetShellIterCommand(), new ListShellIterCommand(), new DeleteShellIterCommand()};
        Command[] otherCommands = new Command[]{new HiddenCommand()};
        Command[] permissionsCommands = new Command[]{new GrantCommand(), new RevokeCommand(), new SystemPermissionsCommand(), new TablePermissionsCommand(), new UserPermissionsCommand(), new NamespacePermissionsCommand()};
        Command[] stateCommands = new Command[]{new AuthenticateCommand(), new ClsCommand(), new ClearCommand(), new FateCommand(), new NoTableCommand(), new SleepCommand(), new TableCommand(), new UserCommand(), new WhoAmICommand()};
        Command[] tableCommands = new Command[]{new CloneTableCommand(), new ConfigCommand(), new CreateTableCommand(), new DeleteTableCommand(), new DropTableCommand(), new DUCommand(), new ExportTableCommand(), new ImportTableCommand(), new OfflineCommand(), new OnlineCommand(), new RenameTableCommand(), new TablesCommand(), new NamespacesCommand(), new CreateNamespaceCommand(), new DeleteNamespaceCommand(), new RenameNamespaceCommand()};
        Command[] tableControlCommands = new Command[]{new AddSplitsCommand(), new CompactCommand(), new ConstraintCommand(), new FlushCommand(), new GetGroupsCommand(), new GetSplitsCommand(), new MergeCommand(), new SetGroupsCommand()};
        Command[] userCommands = new Command[]{new AddAuthsCommand(), new CreateUserCommand(), new DeleteUserCommand(), new DropUserCommand(), new GetAuthsCommand(), new PasswdCommand(), new SetAuthsCommand(), new UsersCommand(), new DeleteAuthsCommand()};
        this.commandGrouping.put("-- Writing, Reading, and Removing Data --", dataCommands);
        this.commandGrouping.put("-- Debugging Commands -------------------", debuggingCommands);
        this.commandGrouping.put("-- Shell Execution Commands -------------", execCommands);
        this.commandGrouping.put("-- Exiting Commands ---------------------", exitCommands);
        this.commandGrouping.put("-- Help Commands ------------------------", helpCommands);
        this.commandGrouping.put("-- Iterator Configuration ---------------", iteratorCommands);
        this.commandGrouping.put("-- Permissions Administration Commands --", permissionsCommands);
        this.commandGrouping.put("-- Shell State Commands -----------------", stateCommands);
        this.commandGrouping.put("-- Table Administration Commands --------", tableCommands);
        this.commandGrouping.put("-- Table Control Commands ---------------", tableControlCommands);
        this.commandGrouping.put("-- User Administration Commands ---------", userCommands);
        for (Command[] cmds : this.commandGrouping.values()) {
            for (Command cmd : cmds) {
                this.commandFactory.put(cmd.getName(), cmd);
            }
        }
        for (Command cmd : otherCommands) {
            this.commandFactory.put(cmd.getName(), cmd);
        }
        return true;
    }

    protected void setInstance(ShellOptionsJC options) {
        this.instance = null;
        if (options.isFake()) {
            this.instance = DeprecationUtil.makeMockInstance((String)"fake");
        } else {
            ClientConfiguration clientConf;
            String instanceName;
            String hosts;
            if (options.isHdfsZooInstance()) {
                hosts = null;
                instanceName = null;
            } else if (options.getZooKeeperInstance().size() > 0) {
                List<String> zkOpts = options.getZooKeeperInstance();
                instanceName = zkOpts.get(0);
                hosts = zkOpts.get(1);
            } else {
                instanceName = options.getZooKeeperInstanceName();
                hosts = options.getZooKeeperHosts();
            }
            try {
                clientConf = options.getClientConfiguration();
            }
            catch (FileNotFoundException | ConfigurationException e) {
                throw new IllegalArgumentException("Unable to load client config from " + options.getClientConfigFile(), e);
            }
            this.instance = Shell.getZooInstance(instanceName, hosts, clientConf);
        }
    }

    static String getZooKeepers(String keepers, ClientConfiguration clientConfig) {
        if (null != keepers) {
            return keepers;
        }
        if (clientConfig.containsKey(ClientConfiguration.ClientProperty.INSTANCE_ZK_HOST.getKey())) {
            return clientConfig.get(ClientConfiguration.ClientProperty.INSTANCE_ZK_HOST);
        }
        return SiteConfiguration.getInstance().get(Property.INSTANCE_ZK_HOST);
    }

    private static Instance getZooInstance(String instanceName, String keepersOption, ClientConfiguration clientConfig) {
        UUID instanceId = null;
        if (instanceName == null) {
            instanceName = clientConfig.get(ClientConfiguration.ClientProperty.INSTANCE_NAME);
        }
        String keepers = Shell.getZooKeepers(keepersOption, clientConfig);
        if (instanceName == null) {
            SiteConfiguration conf = SiteConfiguration.getInstance();
            Path instanceDir = new Path(VolumeConfiguration.getVolumeUris((AccumuloConfiguration)conf)[0], "instance_id");
            instanceId = UUID.fromString(ZooUtil.getInstanceIDFromHdfs((Path)instanceDir, (AccumuloConfiguration)conf));
        }
        if (instanceId != null) {
            return new ZooKeeperInstance(clientConfig.withInstance(instanceId).withZkHosts(keepers));
        }
        return new ZooKeeperInstance(clientConfig.withInstance(instanceName).withZkHosts(keepers));
    }

    public Connector getConnector() {
        return this.connector;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public ClassLoader getClassLoader(CommandLine cl, Shell shellState) throws AccumuloException, TableNotFoundException, AccumuloSecurityException, IOException, FileSystemException {
        ClassLoader classloader;
        Iterable tableProps;
        boolean tables = cl.hasOption(OptUtil.tableOpt().getOpt()) || !shellState.getTableName().isEmpty();
        boolean namespaces = cl.hasOption(OptUtil.namespaceOpt().getOpt());
        String classpath = null;
        if (namespaces) {
            try {
                tableProps = shellState.getConnector().namespaceOperations().getProperties(OptUtil.getNamespaceOpt(cl, shellState));
            }
            catch (NamespaceNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        } else if (tables) {
            tableProps = shellState.getConnector().tableOperations().getProperties(OptUtil.getTableOpt(cl, shellState));
        } else {
            throw new IllegalArgumentException("No table or namespace specified");
        }
        for (Map.Entry entry : tableProps) {
            if (!((String)entry.getKey()).equals(Property.TABLE_CLASSPATH.getKey())) continue;
            classpath = (String)entry.getValue();
        }
        if (classpath != null && !classpath.equals("")) {
            shellState.getConnector().instanceOperations().getSystemConfiguration().get(Property.VFS_CONTEXT_CLASSPATH_PROPERTY.getKey() + classpath);
            try {
                final Map systemConfig = shellState.getConnector().instanceOperations().getSystemConfiguration();
                AccumuloVFSClassLoader.getContextManager().setContextConfig((ContextManager.ContextsConfig)new ContextManager.DefaultContextsConfig(){

                    public Map<String, String> getVfsContextClasspathProperties() {
                        HashMap<String, String> filteredMap = new HashMap<String, String>();
                        for (Map.Entry entry : systemConfig.entrySet()) {
                            if (!((String)entry.getKey()).startsWith(Property.VFS_CONTEXT_CLASSPATH_PROPERTY.getKey())) continue;
                            filteredMap.put((String)entry.getKey(), (String)entry.getValue());
                        }
                        return filteredMap;
                    }
                });
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            classloader = AccumuloVFSClassLoader.getContextManager().getClassLoader(classpath);
        } else {
            classloader = AccumuloVFSClassLoader.getClassLoader();
        }
        return classloader;
    }

    public String keyword() {
        return "shell";
    }

    public void execute(String[] args) throws IOException {
        try {
            if (!this.config(args)) {
                System.exit(this.getExitCode());
            }
            System.exit(this.start());
        }
        finally {
            this.shutdown();
            DistributedTrace.disable();
        }
    }

    public static void main(String[] args) throws IOException {
        new Shell(new ConsoleReader()).execute(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start() throws IOException {
        String home;
        if (this.isVerbose()) {
            this.printInfo();
        }
        if ((home = System.getProperty("HOME")) == null) {
            home = System.getenv("HOME");
        }
        String configDir = home + "/" + HISTORY_DIR_NAME;
        String historyPath = configDir + "/" + HISTORY_FILE_NAME;
        File accumuloDir = new File(configDir);
        if (!accumuloDir.exists() && !accumuloDir.mkdirs()) {
            log.warn((Object)("Unable to make directory for history at " + accumuloDir));
        }
        try {
            final FileHistory history = new FileHistory(new File(historyPath));
            this.reader.setHistory((History)history);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        history.flush();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Could not flush history to file.");
                    }
                }
            });
        }
        catch (IOException e) {
            log.warn((Object)("Unable to load history file at " + historyPath));
        }
        this.reader.setHandleUserInterrupt(true);
        ShellCompletor userCompletor = null;
        if (this.execFile != null) {
            try (Scanner scanner = new Scanner(this.execFile, StandardCharsets.UTF_8.name());){
                while (scanner.hasNextLine() && !this.hasExited()) {
                    this.execCommand(scanner.nextLine(), true, this.isVerbose());
                }
            }
        } else if (this.execCommand != null) {
            for (String command : this.execCommand.split("\n")) {
                this.execCommand(command, true, this.isVerbose());
            }
            return this.exitCode;
        }
        while (true) {
            try {
                if (this.hasExited()) {
                    int scanner = this.exitCode;
                    return scanner;
                }
                if (this.tabCompletion) {
                    if (userCompletor != null) {
                        this.reader.removeCompleter((Completer)userCompletor);
                    }
                    userCompletor = this.setupCompletion();
                    this.reader.addCompleter((Completer)userCompletor);
                }
                this.reader.setPrompt(this.getDefaultPrompt());
                String input = this.reader.readLine();
                if (input == null) {
                    this.reader.println();
                    int scanner = this.exitCode;
                    return scanner;
                }
                this.execCommand(input, this.disableAuthTimeout, false);
                continue;
            }
            catch (UserInterruptException uie) {
                this.reader.println();
                String partialLine = uie.getPartialLine();
                if (partialLine != null && !"".equals(uie.getPartialLine().trim())) continue;
                int n = this.exitCode;
                return n;
            }
            finally {
                this.reader.flush();
                continue;
            }
            break;
        }
    }

    public void shutdown() {
        if (this.reader != null) {
            this.reader.shutdown();
        }
    }

    public void printInfo() throws IOException {
        this.reader.print((CharSequence)("\nShell - Apache Accumulo Interactive Shell\n- \n- version: 1.10.4\n- instance name: " + this.connector.getInstance().getInstanceName() + "\n- instance id: " + this.connector.getInstance().getInstanceID() + "\n- \n- type 'help' for a list of available commands\n- \n"));
        this.reader.flush();
    }

    public void printVerboseInfo() throws IOException {
        StringBuilder sb = new StringBuilder("-\n");
        sb.append("- Current user: ").append(this.connector.whoami()).append("\n");
        if (this.execFile != null) {
            sb.append("- Executing commands from: ").append(this.execFile).append("\n");
        }
        if (this.disableAuthTimeout) {
            sb.append("- Authorization timeout: disabled\n");
        } else {
            sb.append("- Authorization timeout: ").append(String.format("%ds%n", TimeUnit.NANOSECONDS.toSeconds(this.authTimeout)));
        }
        sb.append("- Debug: ").append(Shell.isDebuggingEnabled() ? "on" : "off").append("\n");
        if (!this.scanIteratorOptions.isEmpty()) {
            for (Map.Entry<String, List<IteratorSetting>> entry : this.scanIteratorOptions.entrySet()) {
                sb.append("- Session scan iterators for table ").append(entry.getKey()).append(":\n");
                for (IteratorSetting setting : entry.getValue()) {
                    sb.append("-    Iterator ").append(setting.getName()).append(" options:\n");
                    sb.append("-        ").append("iteratorPriority").append(" = ").append(setting.getPriority()).append("\n");
                    sb.append("-        ").append("iteratorClassName").append(" = ").append(setting.getIteratorClass()).append("\n");
                    for (Map.Entry optEntry : setting.getOptions().entrySet()) {
                        sb.append("-        ").append((String)optEntry.getKey()).append(" = ").append((String)optEntry.getValue()).append("\n");
                    }
                }
            }
        }
        sb.append("-\n");
        this.reader.print((CharSequence)sb.toString());
    }

    public String getDefaultPrompt() {
        return this.connector.whoami() + "@" + this.connector.getInstance().getInstanceName() + (this.getTableName().isEmpty() ? "" : " ") + this.getTableName() + "> ";
    }

    public void execCommand(String input, boolean ignoreAuthTimeout, boolean echoPrompt) throws IOException {
        block23: {
            String[] fields;
            audit.log((Priority)Level.INFO, (Object)(this.getDefaultPrompt() + input));
            if (echoPrompt) {
                this.reader.print((CharSequence)this.getDefaultPrompt());
                this.reader.println((CharSequence)input);
            }
            if (input.startsWith(COMMENT_PREFIX)) {
                return;
            }
            try {
                fields = new QuotedStringTokenizer(input).getTokens();
            }
            catch (BadArgumentException e) {
                this.printException((Exception)((Object)e));
                ++this.exitCode;
                return;
            }
            if (fields.length == 0) {
                return;
            }
            String command = fields[0];
            fields = fields.length > 1 ? Arrays.copyOfRange(fields, 1, fields.length) : new String[]{};
            Command sc = null;
            if (command.length() > 0) {
                try {
                    sc = this.commandFactory.get(command);
                    if (sc == null) {
                        this.reader.println((CharSequence)String.format("Unknown command \"%s\".  Enter \"help\" for a list possible commands.", command));
                        this.reader.flush();
                        return;
                    }
                    long duration = System.nanoTime() - this.lastUserActivity;
                    if (!(sc instanceof ExitCommand || ignoreAuthTimeout || duration >= 0L && duration <= this.authTimeout)) {
                        this.reader.println((CharSequence)"Shell has been idle for too long. Please re-authenticate.");
                        boolean authFailed = true;
                        do {
                            String pwd;
                            if ((pwd = this.readMaskedLine("Enter current password for '" + this.connector.whoami() + "': ", Character.valueOf('*'))) == null) {
                                this.reader.println();
                                return;
                            }
                            try {
                                authFailed = !this.connector.securityOperations().authenticateUser(this.connector.whoami(), (AuthenticationToken)new PasswordToken((CharSequence)pwd));
                            }
                            catch (Exception e) {
                                ++this.exitCode;
                                this.printException(e);
                            }
                            if (!authFailed) continue;
                            this.reader.print((CharSequence)"Invalid password. ");
                        } while (authFailed);
                        this.lastUserActivity = System.nanoTime();
                    }
                    Options parseOpts = sc.getOptionsWithHelp();
                    CommandLine cl = new DefaultParser().parse(parseOpts, fields);
                    int actualArgLen = cl.getArgs().length;
                    int expectedArgLen = sc.numArgs();
                    if (cl.hasOption("?")) {
                        sc.printHelp(this);
                        break block23;
                    }
                    if (expectedArgLen != -1 && actualArgLen != expectedArgLen) {
                        ++this.exitCode;
                        this.printException(new IllegalArgumentException(String.format("Expected %d argument%s. There %s %d.", expectedArgLen, expectedArgLen == 1 ? "" : "s", actualArgLen == 1 ? "was" : "were", actualArgLen)));
                        sc.printHelp(this);
                        break block23;
                    }
                    int tmpCode = sc.execute(input, cl, this);
                    this.exitCode += tmpCode;
                    this.reader.flush();
                }
                catch (ConstraintViolationException e) {
                    ++this.exitCode;
                    this.printConstraintViolationException(e);
                }
                catch (TableNotFoundException e) {
                    ++this.exitCode;
                    if (this.getTableName().equals(e.getTableName())) {
                        this.setTableName("");
                    }
                    this.printException((Exception)((Object)e));
                }
                catch (ParseException e) {
                    if (!(e instanceof MissingOptionException) || !Arrays.asList(fields).contains("-?") && !Arrays.asList(fields).contains("--help")) {
                        ++this.exitCode;
                        this.printException((Exception)((Object)e));
                    }
                    sc.printHelp(this);
                }
                catch (UserInterruptException e) {
                    ++this.exitCode;
                }
                catch (Exception e) {
                    ++this.exitCode;
                    this.printException(e);
                }
            } else {
                ++this.exitCode;
                this.printException((Exception)((Object)new BadArgumentException("Unrecognized empty command", command, -1)));
            }
        }
        this.reader.flush();
    }

    private ShellCompletor setupCompletion() {
        this.rootToken = new Token();
        Set<Object> tableNames = null;
        try {
            tableNames = this.connector.tableOperations().list();
        }
        catch (Exception e) {
            log.debug((Object)"Unable to obtain list of tables", (Throwable)e);
            tableNames = Collections.emptySet();
        }
        Set<String> userlist = null;
        try {
            userlist = this.connector.securityOperations().listLocalUsers();
        }
        catch (Exception e) {
            log.debug((Object)"Unable to obtain list of users", (Throwable)e);
            userlist = Collections.emptySet();
        }
        Set<Object> namespaces = null;
        try {
            namespaces = this.connector.namespaceOperations().list();
        }
        catch (Exception e) {
            log.debug((Object)"Unable to obtain list of namespaces", (Throwable)e);
            namespaces = Collections.emptySet();
        }
        HashMap<Command.CompletionSet, Set<String>> options = new HashMap<Command.CompletionSet, Set<String>>();
        HashSet<String> commands = new HashSet<String>();
        for (String a : this.commandFactory.keySet()) {
            commands.add(a);
        }
        HashSet<String> modifiedUserlist = new HashSet<String>();
        HashSet<String> modifiedTablenames = new HashSet<String>();
        HashSet<String> modifiedNamespaces = new HashSet<String>();
        for (String string : tableNames) {
            modifiedTablenames.add(string.replaceAll("([\\s'\"])", "\\\\$1"));
        }
        for (String string : userlist) {
            modifiedUserlist.add(string.replaceAll("([\\s'\"])", "\\\\$1"));
        }
        for (String string : namespaces) {
            String b = string.replaceAll("([\\s'\"])", "\\\\$1");
            modifiedNamespaces.add(b.isEmpty() ? "\"\"" : b);
        }
        options.put(Command.CompletionSet.USERNAMES, modifiedUserlist);
        options.put(Command.CompletionSet.TABLENAMES, modifiedTablenames);
        options.put(Command.CompletionSet.NAMESPACES, modifiedNamespaces);
        options.put(Command.CompletionSet.COMMANDS, commands);
        Iterator<Object> iterator = this.commandGrouping.values().iterator();
        while (iterator.hasNext()) {
            Command[] commandArray;
            for (Command c : commandArray = (Command[])iterator.next()) {
                c.getOptionsWithHelp();
                c.registerCompletion(this.rootToken, options);
            }
        }
        return new ShellCompletor(this.rootToken, options);
    }

    public final void printLines(Iterator<String> lines, boolean paginate) throws IOException {
        this.printLines(lines, paginate, null);
    }

    public final void printLines(Iterator<String> lines, boolean paginate, PrintLine out) throws IOException {
        int linesPrinted = 0;
        String prompt = "-- hit any key to continue or 'q' to quit --";
        int lastPromptLength = prompt.length();
        int termWidth = this.reader.getTerminal().getWidth();
        int maxLines = this.reader.getTerminal().getHeight();
        String peek = null;
        while (lines.hasNext()) {
            String nextLine = lines.next();
            if (nextLine == null) continue;
            for (String line : nextLine.split("\\n")) {
                if (out == null) {
                    if (peek != null) {
                        this.reader.println((CharSequence)peek);
                        if (paginate && (double)(linesPrinted = (int)((double)linesPrinted + (peek.length() == 0 ? 0.0 : Math.ceil((double)peek.length() * 1.0 / (double)termWidth)))) + Math.ceil((double)lastPromptLength * 1.0 / (double)termWidth) + Math.ceil((double)prompt.length() * 1.0 / (double)termWidth) + Math.ceil((double)line.length() * 1.0 / (double)termWidth) > (double)maxLines) {
                            linesPrinted = 0;
                            int numdashes = (termWidth - prompt.length()) / 2;
                            String nextPrompt = Shell.repeat("-", numdashes) + prompt + Shell.repeat("-", numdashes);
                            lastPromptLength = nextPrompt.length();
                            this.reader.print((CharSequence)nextPrompt);
                            this.reader.flush();
                            if (Character.toUpperCase((char)this.reader.readCharacter()) == 'Q') {
                                this.reader.println();
                                return;
                            }
                            this.reader.println();
                            termWidth = this.reader.getTerminal().getWidth();
                            maxLines = this.reader.getTerminal().getHeight();
                        }
                    }
                    peek = line;
                    continue;
                }
                out.print(line);
            }
        }
        if (out == null && peek != null) {
            this.reader.println(peek);
        }
    }

    public final void printRecords(Iterable<Map.Entry<Key, Value>> scanner, FormatterConfig config, boolean paginate, Class<? extends Formatter> formatterClass, PrintLine outFile) throws IOException {
        this.printLines((Iterator<String>)FormatterFactory.getFormatter(formatterClass, scanner, (FormatterConfig)config), paginate, outFile);
    }

    public final void printRecords(Iterable<Map.Entry<Key, Value>> scanner, FormatterConfig config, boolean paginate, Class<? extends Formatter> formatterClass) throws IOException {
        this.printLines((Iterator<String>)FormatterFactory.getFormatter(formatterClass, scanner, (FormatterConfig)config), paginate);
    }

    public static String repeat(String s, int c) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < c; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public void checkTableState() {
        if (this.getTableName().isEmpty()) {
            throw new IllegalStateException("Not in a table context. Please use 'table <tableName>' to switch to a table, or use '-t' to specify a table if option is available.");
        }
    }

    private final void printConstraintViolationException(ConstraintViolationException cve) {
        this.printException((Exception)((Object)cve), "");
        int COL1 = 50;
        int COL2 = 14;
        int col3 = Math.max(1, Math.min(Integer.MAX_VALUE, this.reader.getTerminal().getWidth() - COL1 - COL2 - 6));
        this.logError(String.format("%" + COL1 + "s-+-%" + COL2 + "s-+-%" + col3 + "s%n", Shell.repeat("-", COL1), Shell.repeat("-", COL2), Shell.repeat("-", col3)));
        this.logError(String.format("%-" + COL1 + "s | %" + COL2 + "s | %-" + col3 + "s%n", "Constraint class", "Violation code", "Violation Description"));
        this.logError(String.format("%" + COL1 + "s-+-%" + COL2 + "s-+-%" + col3 + "s%n", Shell.repeat("-", COL1), Shell.repeat("-", COL2), Shell.repeat("-", col3)));
        for (TConstraintViolationSummary cvs : cve.violationSummaries) {
            this.logError(String.format("%-" + COL1 + "s | %" + COL2 + "d | %-" + col3 + "s%n", cvs.constrainClass, cvs.violationCode, cvs.violationDescription));
        }
        this.logError(String.format("%" + COL1 + "s-+-%" + COL2 + "s-+-%" + col3 + "s%n", Shell.repeat("-", COL1), Shell.repeat("-", COL2), Shell.repeat("-", col3)));
    }

    public final void printException(Exception e) {
        this.printException(e, e.getMessage());
    }

    private final void printException(Exception e, String msg) {
        this.logError(e.getClass().getName() + (msg != null ? ": " + msg : ""));
        log.debug((Object)(e.getClass().getName() + (msg != null ? ": " + msg : "")), (Throwable)e);
    }

    public static final void setDebugging(boolean debuggingEnabled) {
        Logger.getLogger((String)"org.apache.accumulo.core").setLevel(debuggingEnabled ? Level.TRACE : Level.INFO);
        Logger.getLogger((String)Shell.class.getPackage().getName()).setLevel(debuggingEnabled ? Level.TRACE : Level.INFO);
    }

    public static final boolean isDebuggingEnabled() {
        return Logger.getLogger((String)"org.apache.accumulo.core").isTraceEnabled();
    }

    private final void printHelp(String usage, String description, Options opts) throws IOException {
        this.printHelp(usage, description, opts, Integer.MAX_VALUE);
    }

    private final void printHelp(String usage, String description, Options opts, int width) throws IOException {
        new HelpFormatter().printHelp(new PrintWriter(this.reader.getOutput()), width, usage, description, opts, 2, 5, null, true);
        this.reader.getOutput().flush();
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void resetExitCode() {
        this.exitCode = 0;
    }

    public void setExit(boolean exit) {
        this.exit = exit;
    }

    public boolean getExit() {
        return this.exit;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName == null || tableName.isEmpty() ? "" : Tables.qualified((String)tableName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public ConsoleReader getReader() {
        return this.reader;
    }

    public void updateUser(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        this.connector = this.instance.getConnector(principal, token);
        this.token = token;
    }

    public String getPrincipal() {
        return this.connector.whoami();
    }

    public AuthenticationToken getToken() {
        return this.token;
    }

    public Class<? extends Formatter> getFormatter() {
        return this.getFormatter(this.tableName);
    }

    public Class<? extends Formatter> getFormatter(String tableName) {
        Class<? extends Formatter> formatter = FormatterCommand.getCurrentFormatter(tableName, this);
        if (null == formatter) {
            this.logError("Could not load the specified formatter. Using the DefaultFormatter");
            return this.defaultFormatterClass;
        }
        return formatter;
    }

    public void setLogErrorsToConsole() {
        this.logErrorsToConsole = true;
    }

    private void logError(String s) {
        log.error((Object)s);
        if (this.logErrorsToConsole) {
            try {
                this.reader.println((CharSequence)("ERROR: " + s));
                this.reader.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String readMaskedLine(String prompt, Character mask) throws IOException {
        this.masking = true;
        String s = this.reader.readLine(prompt, mask);
        this.masking = false;
        return s;
    }

    public boolean isMasking() {
        return this.masking;
    }

    public boolean hasExited() {
        return this.exit;
    }

    public boolean isTabCompletion() {
        return this.tabCompletion;
    }

    public static class PrintFile
    implements PrintLine {
        PrintWriter writer;

        public PrintFile(String filename) throws FileNotFoundException {
            this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8)));
        }

        @Override
        public void print(String s) {
            this.writer.println(s);
        }

        @Override
        public void close() {
            this.writer.close();
        }
    }

    public static class PrintShell
    implements PrintLine {
        ConsoleReader reader;

        public PrintShell(ConsoleReader reader) {
            this.reader = reader;
        }

        @Override
        public void print(String s) {
            try {
                this.reader.println((CharSequence)s);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void close() {
        }
    }

    public static interface PrintLine
    extends AutoCloseable {
        public void print(String var1);

        @Override
        public void close();
    }

    public static abstract class Command {
        public void registerCompletionGeneral(Token root, Set<String> args, boolean caseSens) {
            Token t = new Token(args);
            t.setCaseSensitive(caseSens);
            Token command = new Token(this.getName());
            command.addSubcommand(t);
            root.addSubcommand(command);
        }

        public void registerCompletionForTables(Token root, Map<CompletionSet, Set<String>> completionSet) {
            this.registerCompletionGeneral(root, completionSet.get((Object)CompletionSet.TABLENAMES), true);
        }

        public void registerCompletionForUsers(Token root, Map<CompletionSet, Set<String>> completionSet) {
            this.registerCompletionGeneral(root, completionSet.get((Object)CompletionSet.USERNAMES), true);
        }

        public void registerCompletionForCommands(Token root, Map<CompletionSet, Set<String>> completionSet) {
            this.registerCompletionGeneral(root, completionSet.get((Object)CompletionSet.COMMANDS), false);
        }

        public void registerCompletionForNamespaces(Token root, Map<CompletionSet, Set<String>> completionSet) {
            this.registerCompletionGeneral(root, completionSet.get((Object)CompletionSet.NAMESPACES), true);
        }

        public abstract int execute(String var1, CommandLine var2, Shell var3) throws Exception;

        public abstract String description();

        public abstract int numArgs();

        public String getName() {
            String s = this.getClass().getName();
            int st = Math.max(s.lastIndexOf(36), s.lastIndexOf(46));
            int i = s.indexOf("Command");
            return i > 0 ? s.substring(st + 1, i).toLowerCase(Locale.ENGLISH) : null;
        }

        public void registerCompletion(Token root, Map<CompletionSet, Set<String>> completion_set) {
            root.addSubcommand(new Token(this.getName()));
        }

        public final void printHelp(Shell shellState) throws IOException {
            shellState.printHelp(this.usage(), "description: " + this.description(), this.getOptionsWithHelp());
        }

        public final void printHelp(Shell shellState, int width) throws IOException {
            shellState.printHelp(this.usage(), "description: " + this.description(), this.getOptionsWithHelp(), width);
        }

        public final Options getOptionsWithHelp() {
            Options opts = this.getOptions();
            opts.addOption(new Option("?", "help", false, "display this help"));
            return opts;
        }

        public String usage() {
            return this.getName();
        }

        public Options getOptions() {
            return new Options();
        }

        public static enum CompletionSet {
            TABLENAMES,
            USERNAMES,
            COMMANDS,
            NAMESPACES;

        }
    }
}

