/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.transaction;

import io.atomix.core.transaction.CommitStatus;
import io.atomix.core.transaction.Isolation;
import io.atomix.core.transaction.Transaction;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionalMapBuilder;
import io.atomix.core.transaction.TransactionalSetBuilder;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.primitive.protocol.ProxyProtocol;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public interface AsyncTransaction
extends AsyncPrimitive {
    public TransactionId transactionId();

    public Isolation isolation();

    public boolean isOpen();

    public CompletableFuture<Void> begin();

    public CompletableFuture<CommitStatus> commit();

    public CompletableFuture<Void> abort();

    public <K, V> TransactionalMapBuilder<K, V> mapBuilder(String var1);

    default public <K, V> TransactionalMapBuilder<K, V> mapBuilder(String name, ProxyProtocol protocol) {
        return this.mapBuilder(name).withProtocol(protocol);
    }

    public <E> TransactionalSetBuilder<E> setBuilder(String var1);

    default public <E> TransactionalSetBuilder<E> setBuilder(String name, ProxyProtocol protocol) {
        return this.setBuilder(name).withProtocol(protocol);
    }

    default public Transaction sync() {
        return this.sync(Duration.ofMillis(5000L));
    }

    public Transaction sync(Duration var1);
}

