/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.set.impl;

import io.atomix.core.set.AsyncDistributedSortedSet;
import io.atomix.core.set.DistributedSortedSet;
import io.atomix.core.set.DistributedSortedSetBuilder;
import io.atomix.core.set.DistributedSortedSetConfig;
import io.atomix.core.set.impl.CachingAsyncDistributedNavigableSet;
import io.atomix.core.set.impl.DistributedNavigableSetProxy;
import io.atomix.core.set.impl.DistributedTreeSetService;
import io.atomix.core.set.impl.GossipDistributedSortedSet;
import io.atomix.core.set.impl.UnmodifiableAsyncDistributedNavigableSet;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.protocol.GossipProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.set.SortedSetProtocol;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.utils.concurrent.Futures;
import java.util.concurrent.CompletableFuture;

public class DefaultDistributedSortedSetBuilder<E extends Comparable<E>>
extends DistributedSortedSetBuilder<E> {
    public DefaultDistributedSortedSetBuilder(String name, DistributedSortedSetConfig config, PrimitiveManagementService managementService) {
        super(name, config, managementService);
    }

    public CompletableFuture<DistributedSortedSet<E>> buildAsync() {
        PrimitiveProtocol protocol = this.protocol();
        if (protocol instanceof GossipProtocol) {
            if (protocol instanceof SortedSetProtocol) {
                return this.managementService.getPrimitiveCache().getPrimitive(this.name, () -> CompletableFuture.completedFuture(((SortedSetProtocol)protocol).newSortedSetDelegate(this.name, this.serializer(), this.managementService)).thenApply(set -> new GossipDistributedSortedSet(this.name, protocol, set))).thenApply(AsyncDistributedSortedSet::sync);
            }
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException("Sets are not supported by the provided gossip protocol"));
        }
        return ((CompletableFuture)this.newProxy(DistributedTreeSetService.class, new ServiceConfig()).thenCompose(proxy -> new DistributedNavigableSetProxy(proxy, this.managementService.getPrimitiveRegistry()).connect())).thenApply(set -> {
            if (((DistributedSortedSetConfig)this.config).getCacheConfig().isEnabled()) {
                set = new CachingAsyncDistributedNavigableSet(set, ((DistributedSortedSetConfig)this.config).getCacheConfig());
            }
            if (((DistributedSortedSetConfig)this.config).isReadOnly()) {
                set = new UnmodifiableAsyncDistributedNavigableSet(set);
            }
            return set.sync();
        });
    }
}

