/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.set.impl;

import io.atomix.core.iterator.impl.BlockingIterator;
import io.atomix.core.set.AsyncDistributedNavigableSet;
import io.atomix.core.set.DistributedNavigableSet;
import io.atomix.core.set.impl.BlockingDistributedSortedSet;
import java.util.Iterator;
import java.util.NavigableSet;

public class BlockingDistributedNavigableSet<E extends Comparable<E>>
extends BlockingDistributedSortedSet<E>
implements DistributedNavigableSet<E> {
    private final long operationTimeoutMillis;
    private final AsyncDistributedNavigableSet<E> asyncSet;

    public BlockingDistributedNavigableSet(AsyncDistributedNavigableSet<E> asyncSet, long operationTimeoutMillis) {
        super(asyncSet, operationTimeoutMillis);
        this.asyncSet = asyncSet;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public E lower(E e) {
        return (E)((Comparable)this.complete(this.asyncSet.lower(e)));
    }

    @Override
    public E floor(E e) {
        return (E)((Comparable)this.complete(this.asyncSet.floor(e)));
    }

    @Override
    public E ceiling(E e) {
        return (E)((Comparable)this.complete(this.asyncSet.ceiling(e)));
    }

    @Override
    public E higher(E e) {
        return (E)((Comparable)this.complete(this.asyncSet.higher(e)));
    }

    @Override
    public E pollFirst() {
        return (E)((Comparable)this.complete(this.asyncSet.pollFirst()));
    }

    @Override
    public E pollLast() {
        return (E)((Comparable)this.complete(this.asyncSet.pollLast()));
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new BlockingDistributedNavigableSet<E>(this.asyncSet.descendingSet(), this.operationTimeoutMillis);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new BlockingIterator<E>(this.asyncSet.descendingIterator(), this.operationTimeoutMillis);
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new BlockingDistributedNavigableSet<E>(this.asyncSet.subSet(fromElement, fromInclusive, toElement, toInclusive), this.operationTimeoutMillis);
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new BlockingDistributedNavigableSet<E>(this.asyncSet.headSet(toElement, inclusive), this.operationTimeoutMillis);
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new BlockingDistributedNavigableSet<E>(this.asyncSet.tailSet(fromElement, inclusive), this.operationTimeoutMillis);
    }

    @Override
    public AsyncDistributedNavigableSet<E> async() {
        return this.asyncSet;
    }
}

