/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.semaphore.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.atomix.core.semaphore.AtomicSemaphoreType;
import io.atomix.core.semaphore.QueueStatus;
import io.atomix.core.semaphore.impl.AtomicSemaphoreClient;
import io.atomix.core.semaphore.impl.AtomicSemaphoreService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class AbstractAtomicSemaphoreService
extends AbstractPrimitiveService<AtomicSemaphoreClient>
implements AtomicSemaphoreService {
    private static final Serializer SERIALIZER = Serializer.using((Namespace)Namespace.builder().register(AtomicSemaphoreType.instance().namespace()).register(new Class[]{Waiter.class}).build());
    private int available;
    private Map<Long, Integer> holders = new HashMap<Long, Integer>();
    private LinkedList<Waiter> waiterQueue = new LinkedList();
    private final Map<Long, Scheduled> timers = new HashMap<Long, Scheduled>();

    public AbstractAtomicSemaphoreService(PrimitiveType primitiveType, int initialCapacity) {
        super(primitiveType, AtomicSemaphoreClient.class);
        this.available = initialCapacity;
    }

    public void backup(BackupOutput output) {
        output.writeInt(this.available);
        output.writeObject(this.holders, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0));
        output.writeObject(this.waiterQueue, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0));
    }

    public void restore(BackupInput input) {
        this.available = input.readInt();
        this.holders = (Map)input.readObject(arg_0 -> ((Serializer)SERIALIZER).decode(arg_0));
        this.waiterQueue = (LinkedList)input.readObject(arg_0 -> ((Serializer)SERIALIZER).decode(arg_0));
        this.timers.values().forEach(Scheduled::cancel);
        this.timers.clear();
        for (Waiter waiter : this.waiterQueue) {
            if (waiter.expire <= 0L) continue;
            this.timers.put(waiter.index, this.getScheduler().schedule(Duration.ofMillis(waiter.expire - this.getWallClock().getTime().unixTimestamp()), () -> {
                this.timers.remove(waiter.index);
                this.waiterQueue.remove(waiter);
                this.fail(waiter.session, waiter.id);
            }));
        }
    }

    public void onExpire(Session session) {
        this.releaseSession(session);
    }

    public void onClose(Session session) {
        this.releaseSession(session);
    }

    @Override
    public void acquire(long id, int permits, long timeout) {
        Session session = this.getCurrentSession();
        if (this.available >= permits) {
            this.acquire(session.sessionId(), id, permits, this.getCurrentIndex());
        } else if (timeout > 0L) {
            Waiter waiter = new Waiter(session.sessionId(), this.getCurrentIndex(), id, permits, this.getWallClock().getTime().unixTimestamp() + timeout);
            this.waiterQueue.add(waiter);
            this.timers.put(this.getCurrentIndex(), this.getScheduler().schedule(timeout, TimeUnit.MILLISECONDS, () -> {
                this.timers.remove(this.getCurrentIndex());
                this.waiterQueue.remove(waiter);
                this.fail(session.sessionId(), id);
            }));
        } else if (timeout == 0L) {
            this.fail(session.sessionId(), id);
        } else {
            this.waiterQueue.add(new Waiter(session.sessionId(), this.getCurrentIndex(), id, permits, 0L));
        }
    }

    @Override
    public void release(int permits) {
        this.release((Long)this.getCurrentSession().sessionId().id(), permits);
    }

    @Override
    public int available() {
        return this.available;
    }

    @Override
    public int drain() {
        int acquirePermits = this.available;
        this.available = 0;
        if (acquirePermits > 0) {
            this.holders.compute((Long)this.getCurrentSession().sessionId().id(), (k, v) -> {
                if (v == null) {
                    v = 0;
                }
                return v + acquirePermits;
            });
        }
        return acquirePermits;
    }

    @Override
    public int increase(int permits) {
        this.increaseAvailable(permits);
        this.checkAndNotifyWaiters();
        return this.available;
    }

    @Override
    public int reduce(int permits) {
        return this.decreaseAvailable(permits);
    }

    @Override
    public QueueStatus queueStatus() {
        int permits = this.waiterQueue.stream().map(w -> ((Waiter)w).acquirePermits).reduce(0, Integer::sum);
        return new QueueStatus(this.waiterQueue.size(), permits);
    }

    @Override
    public Map<Long, Integer> holderStatus() {
        return this.holders;
    }

    private void acquire(SessionId sessionId, long operationId, int acquirePermits, long version) {
        this.decreaseAvailable(acquirePermits);
        this.holders.compute((Long)sessionId.id(), (k, v) -> {
            if (v == null) {
                v = 0;
            }
            return v + acquirePermits;
        });
        this.success(sessionId, operationId, acquirePermits, version);
    }

    private void release(long sessionId, int releasePermits) {
        this.increaseAvailable(releasePermits);
        this.holders.computeIfPresent(sessionId, (id, acquired) -> {
            if ((acquired = Integer.valueOf(acquired - releasePermits)) <= 0) {
                return null;
            }
            return acquired;
        });
        this.checkAndNotifyWaiters();
    }

    private void success(SessionId sessionId, long operationId, int acquirePermits, long version) {
        this.getSession(sessionId).accept(client -> client.succeeded(operationId, version, acquirePermits));
    }

    private void fail(SessionId sessionId, long operationId) {
        this.getSession(sessionId).accept(client -> client.failed(operationId));
    }

    private void releaseSession(Session session) {
        if (this.holders.containsKey(session.sessionId().id())) {
            this.release((Long)session.sessionId().id(), this.holders.get(session.sessionId().id()));
        }
    }

    private void checkAndNotifyWaiters() {
        Iterator iterator = this.waiterQueue.iterator();
        while (iterator.hasNext() && this.available > 0) {
            Waiter waiter = (Waiter)iterator.next();
            if (this.available < waiter.acquirePermits) continue;
            iterator.remove();
            Scheduled timer = this.timers.remove(waiter.index);
            if (timer != null) {
                timer.cancel();
            }
            this.acquire(waiter.session, waiter.id, waiter.acquirePermits, waiter.index);
        }
    }

    private int increaseAvailable(int permits) {
        int newAvailable = this.available + permits;
        if (newAvailable < this.available) {
            newAvailable = Integer.MAX_VALUE;
        }
        this.available = newAvailable;
        return this.available;
    }

    private int decreaseAvailable(int permits) {
        int newAvailable = this.available - permits;
        if (newAvailable > this.available) {
            newAvailable = Integer.MIN_VALUE;
        }
        this.available = newAvailable;
        return this.available;
    }

    public Serializer serializer() {
        return SERIALIZER;
    }

    private class Waiter {
        private final SessionId session;
        private final long index;
        private final long id;
        private final int acquirePermits;
        private final long expire;

        public Waiter(SessionId session, long index, long id, int acquirePermits, long expire) {
            this.session = session;
            this.index = index;
            this.id = id;
            this.acquirePermits = acquirePermits;
            this.expire = expire;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Waiter waiter = (Waiter)o;
            return this.session.equals((Object)waiter.session) && this.index == waiter.index && this.id == waiter.id && this.acquirePermits == waiter.acquirePermits;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.session, this.index, this.id, this.acquirePermits});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("session", (Object)this.session).add("index", this.index).add("id", this.id).add("acquirePermits", this.acquirePermits).add("expire", this.expire).toString();
        }
    }
}

