/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import com.google.common.io.BaseEncoding;
import io.atomix.core.map.AsyncAtomicMap;
import io.atomix.core.map.AsyncDistributedMap;
import io.atomix.core.map.DistributedMap;
import io.atomix.core.map.DistributedMapBuilder;
import io.atomix.core.map.DistributedMapConfig;
import io.atomix.core.map.impl.AtomicMapProxy;
import io.atomix.core.map.impl.AtomicMapService;
import io.atomix.core.map.impl.CachingAsyncAtomicMap;
import io.atomix.core.map.impl.DelegatingAsyncDistributedMap;
import io.atomix.core.map.impl.GossipDistributedMap;
import io.atomix.core.map.impl.NotNullAsyncAtomicMap;
import io.atomix.core.map.impl.TranscodingAsyncAtomicMap;
import io.atomix.core.map.impl.UnmodifiableAsyncAtomicMap;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.primitive.protocol.GossipProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.map.MapProtocol;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;

public class DefaultDistributedMapBuilder<K, V>
extends DistributedMapBuilder<K, V> {
    public DefaultDistributedMapBuilder(String name, DistributedMapConfig config, PrimitiveManagementService managementService) {
        super(name, config, managementService);
    }

    public CompletableFuture<DistributedMap<K, V>> buildAsync() {
        PrimitiveProtocol protocol = this.protocol();
        if (protocol instanceof GossipProtocol) {
            if (protocol instanceof MapProtocol) {
                return this.managementService.getPrimitiveCache().getPrimitive(this.name, () -> CompletableFuture.completedFuture(((MapProtocol)protocol).newMapDelegate(this.name, this.serializer(), this.managementService)).thenApply(map -> new GossipDistributedMap(this.name, protocol, map))).thenApply(AsyncDistributedMap::sync);
            }
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException("Maps are not supported by the provided gossip protocol"));
        }
        return ((CompletableFuture)((CompletableFuture)this.newProxy(AtomicMapService.class, new ServiceConfig()).thenCompose(proxy -> new AtomicMapProxy((ProxyClient<AtomicMapService<String>>)proxy, this.managementService.getPrimitiveRegistry()).connect())).thenApply(rawMap -> {
            Serializer serializer = this.serializer();
            DelegatingAsyncPrimitive map = new TranscodingAsyncAtomicMap<Object, Object, String, byte[]>((AsyncAtomicMap<String, byte[]>)rawMap, key -> BaseEncoding.base16().encode(serializer.encode(key)), string -> serializer.decode(BaseEncoding.base16().decode((CharSequence)string)), value -> serializer.encode(value), bytes -> serializer.decode(bytes));
            if (!((DistributedMapConfig)this.config).isNullValues()) {
                map = new NotNullAsyncAtomicMap(map);
            }
            if (((DistributedMapConfig)this.config).getCacheConfig().isEnabled()) {
                map = new CachingAsyncAtomicMap(map, ((DistributedMapConfig)this.config).getCacheConfig());
            }
            if (((DistributedMapConfig)this.config).isReadOnly()) {
                map = new UnmodifiableAsyncAtomicMap(map);
            }
            return map;
        })).thenApply(atomicMap -> new DelegatingAsyncDistributedMap(atomicMap).sync());
    }
}

