/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.impl;

import io.atomix.core.AtomixRegistry;
import io.atomix.utils.NamedType;
import io.atomix.utils.ServiceException;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScanningAtomixRegistry
implements AtomixRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathScanningAtomixRegistry.class);
    private final Map<Class<? extends NamedType>, Map<String, NamedType>> registrations = new ConcurrentHashMap<Class<? extends NamedType>, Map<String, NamedType>>();

    public ClasspathScanningAtomixRegistry(ClassLoader classLoader, Class<? extends NamedType> ... types) {
        this(classLoader, Arrays.asList(types));
    }

    public ClasspathScanningAtomixRegistry(ClassLoader classLoader, Collection<Class<? extends NamedType>> types) {
        String scanSpec = System.getProperty("io.atomix.scanSpec");
        FastClasspathScanner classpathScanner = scanSpec != null ? new FastClasspathScanner(new String[]{scanSpec}).addClassLoader(classLoader) : new FastClasspathScanner(new String[0]).addClassLoader(classLoader);
        for (Class<? extends NamedType> type : types) {
            ConcurrentHashMap registrations = new ConcurrentHashMap();
            classpathScanner.matchClassesImplementing(type, clazz -> {
                NamedType instance;
                NamedType oldInstance;
                if (!Modifier.isAbstract(clazz.getModifiers()) && !Modifier.isPrivate(clazz.getModifiers()) && (oldInstance = registrations.put((instance = (NamedType)ClasspathScanningAtomixRegistry.newInstance(clazz)).name(), instance)) != null) {
                    LOGGER.warn("Found multiple types with name={}, classes=[{}, {}]", new Object[]{instance.name(), oldInstance.getClass().getName(), instance.getClass().getName()});
                }
            });
            this.registrations.put(type, registrations);
        }
        classpathScanner.scan();
    }

    private static <T> T newInstance(Class<?> type) {
        try {
            return (T)type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServiceException("Cannot instantiate service class " + type, (Throwable)e);
        }
    }

    @Override
    public <T extends NamedType> Collection<T> getTypes(Class<T> type) {
        Map<String, NamedType> types = this.registrations.get(type);
        return types != null ? types.values() : Collections.emptyList();
    }

    @Override
    public <T extends NamedType> T getType(Class<T> type, String name) {
        Map<String, NamedType> types = this.registrations.get(type);
        return (T)(types != null ? types.get(name) : null);
    }
}

