/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.idgenerator.impl;

import io.atomix.core.counter.AsyncAtomicCounter;
import io.atomix.core.idgenerator.AsyncAtomicIdGenerator;
import io.atomix.core.idgenerator.AtomicIdGenerator;
import io.atomix.core.idgenerator.AtomicIdGeneratorType;
import io.atomix.core.idgenerator.impl.BlockingAtomicIdGenerator;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;

public class DelegatingAtomicIdGenerator
extends DelegatingAsyncPrimitive
implements AsyncAtomicIdGenerator {
    private static final long DEFAULT_BATCH_SIZE = 1000L;
    private final AsyncAtomicCounter counter;
    private final long batchSize;
    private CompletableFuture<Long> reserveFuture;
    private long base;
    private final AtomicLong delta = new AtomicLong();

    public DelegatingAtomicIdGenerator(AsyncAtomicCounter counter) {
        this(counter, 1000L);
    }

    public DelegatingAtomicIdGenerator(AsyncAtomicCounter counter, long batchSize) {
        super((AsyncPrimitive)counter);
        this.counter = counter;
        this.batchSize = batchSize;
    }

    public PrimitiveType type() {
        return AtomicIdGeneratorType.instance();
    }

    @Override
    public synchronized CompletableFuture<Long> nextId() {
        long nextDelta = this.delta.incrementAndGet();
        if (this.base == 0L && this.reserveFuture == null || nextDelta > this.batchSize) {
            this.delta.set(0L);
            long delta = this.delta.incrementAndGet();
            return this.reserve().thenApply(base -> base + delta);
        }
        return this.reserveFuture.thenApply(base -> base + nextDelta);
    }

    @Override
    public AtomicIdGenerator sync(Duration operationTimeout) {
        return new BlockingAtomicIdGenerator(this, operationTimeout.toMillis());
    }

    private CompletableFuture<Long> reserve() {
        this.reserveFuture = this.reserveFuture == null || this.reserveFuture.isDone() ? this.counter.getAndAdd(this.batchSize) : this.reserveFuture.thenCompose(v -> this.counter.getAndAdd(this.batchSize));
        this.reserveFuture = this.reserveFuture.thenApply(base -> {
            this.base = base;
            return base;
        });
        return this.reserveFuture;
    }
}

