/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.idgenerator.impl;

import io.atomix.core.idgenerator.AsyncAtomicIdGenerator;
import io.atomix.primitive.resource.PrimitiveResource;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicIdGeneratorResource
implements PrimitiveResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomicIdGeneratorResource.class);
    private final AsyncAtomicIdGenerator idGenerator;

    public AtomicIdGeneratorResource(AsyncAtomicIdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @PUT
    @Produces(value={"application/json"})
    public void next(@Suspended AsyncResponse response) {
        this.idGenerator.nextId().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }
}

