/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.election;

import com.google.common.base.MoreObjects;
import io.atomix.core.election.Leadership;
import io.atomix.utils.event.AbstractEvent;
import java.util.Objects;

public class LeadershipEvent<T>
extends AbstractEvent<Type, Leadership> {
    private final String topic;
    private final Leadership<T> oldLeadership;
    private final Leadership<T> newLeadership;

    public LeadershipEvent(Type type, String topic, Leadership<T> oldLeadership, Leadership<T> newLeadership) {
        this(type, topic, oldLeadership, newLeadership, System.currentTimeMillis());
    }

    public LeadershipEvent(Type type, String topic, Leadership<T> oldLeadership, Leadership<T> newLeadership, long time) {
        super((Enum)type, newLeadership, time);
        this.topic = topic;
        this.oldLeadership = oldLeadership;
        this.newLeadership = newLeadership;
    }

    public String topic() {
        return this.topic;
    }

    public Leadership<T> oldLeadership() {
        return this.oldLeadership;
    }

    public Leadership<T> newLeadership() {
        return this.newLeadership;
    }

    public int hashCode() {
        return Objects.hash(this.type(), this.subject(), this.time());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LeadershipEvent) {
            LeadershipEvent other = (LeadershipEvent)((Object)obj);
            return Objects.equals(this.type(), other.type()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.time(), other.time());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("type", (Object)this.type()).add("topic", (Object)this.topic()).add("oldLeadership", this.oldLeadership()).add("newLeadership", this.newLeadership()).add("time", this.time()).toString();
    }

    public static enum Type {
        CHANGE;

    }
}

