/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetrics;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetricsList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.utils.URLUtils;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class NodeMetricOperationsImpl
extends OperationSupport {
    private static String METRIC_ENDPOINT_URL = "apis/metrics.k8s.io/v1beta1/nodes";

    public NodeMetricOperationsImpl(OkHttpClient client, Config config) {
        super(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public NodeMetricsList metrics() {
        try {
            String resourceUrl = URLUtils.join(this.config.getMasterUrl(), METRIC_ENDPOINT_URL);
            return this.handleMetric(resourceUrl, NodeMetricsList.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public NodeMetrics metrics(String nodeName) {
        try {
            String resourceUrl = URLUtils.join(this.config.getMasterUrl(), METRIC_ENDPOINT_URL, nodeName);
            return this.handleMetric(resourceUrl, NodeMetrics.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public NodeMetricsList metrics(Map<String, Object> labelsMap) {
        try {
            HttpUrl.Builder httpUrlBuilder = HttpUrl.get(URLUtils.join(this.config.getMasterUrl(), METRIC_ENDPOINT_URL)).newBuilder();
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Object> entry : labelsMap.entrySet()) {
                sb.append(entry.getKey()).append("=").append(entry.getValue().toString()).append(",");
            }
            httpUrlBuilder.addQueryParameter("labelSelector", sb.toString().substring(0, sb.toString().length() - 1));
            return this.handleMetric(httpUrlBuilder.build().toString(), NodeMetricsList.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }
}

