/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.launcher.InterpreterLaunchContext;
import org.apache.zeppelin.interpreter.launcher.InterpreterLauncher;
import org.apache.zeppelin.interpreter.launcher.YarnRemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnInterpreterLauncher
extends InterpreterLauncher {
    private static Logger LOGGER = LoggerFactory.getLogger(YarnInterpreterLauncher.class);

    public YarnInterpreterLauncher(ZeppelinConfiguration zConf, RecoveryStorage recoveryStorage) {
        super(zConf, recoveryStorage);
    }

    public InterpreterClient launchDirectly(InterpreterLaunchContext context) throws IOException {
        LOGGER.info("Launching Interpreter: {}", (Object)context.getInterpreterSettingGroup());
        return new YarnRemoteInterpreterProcess(context, context.getProperties(), this.buildEnvFromProperties(context), this.getConnectTimeout(context), this.getConnectPoolSize(context));
    }

    protected Map<String, String> buildEnvFromProperties(InterpreterLaunchContext context) {
        HashMap<String, String> env = new HashMap<String, String>();
        for (Object key : context.getProperties().keySet()) {
            if (!RemoteInterpreterUtils.isEnvString((String)((String)key))) continue;
            env.put((String)key, context.getProperties().getProperty((String)key));
        }
        env.put("INTERPRETER_GROUP_ID", context.getInterpreterGroupId());
        env.put("ZEPPELIN_INTERPRETER_LAUNCHER", "yarn");
        return env;
    }
}

