/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import com.google.common.base.Preconditions;
import io.atomix.utils.config.Config;
import io.atomix.utils.config.ConfigurationException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class MulticastConfig
implements Config {
    private static final String DEFAULT_MULTICAST_IP = "230.0.0.1";
    private static final int DEFAULT_MULTICAST_PORT = 54321;
    private boolean enabled = false;
    private InetAddress group;
    private int port = 54321;

    public MulticastConfig() {
        try {
            this.group = InetAddress.getByName(DEFAULT_MULTICAST_IP);
        }
        catch (UnknownHostException e) {
            this.group = null;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MulticastConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public InetAddress getGroup() {
        return this.group;
    }

    public MulticastConfig setGroup(String group) {
        try {
            InetAddress address = InetAddress.getByName(group);
            if (!address.isMulticastAddress()) {
                throw new ConfigurationException("Invalid multicast group " + group);
            }
            return this.setGroup(address);
        }
        catch (UnknownHostException e) {
            throw new ConfigurationException("Failed to locate multicast group", (Throwable)e);
        }
    }

    public MulticastConfig setGroup(InetAddress group) {
        this.group = (InetAddress)Preconditions.checkNotNull((Object)group);
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public MulticastConfig setPort(int port) {
        this.port = port;
        return this;
    }
}

