/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.repo.GitNotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoWithVersionControl;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubNotebookRepo
extends GitNotebookRepo {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubNotebookRepo.class);
    private ZeppelinConfiguration zeppelinConfiguration;
    private Git git;

    public void init(ZeppelinConfiguration conf) throws IOException {
        super.init(conf);
        LOG.debug("initializing GitHubNotebookRepo");
        this.git = super.getGit();
        this.zeppelinConfiguration = conf;
        this.configureRemoteStream();
        this.pullFromRemoteStream();
        this.pushToRemoteSteam();
    }

    public NotebookRepoWithVersionControl.Revision checkpoint(String noteId, String notePath, String commitMessage, AuthenticationInfo subject) throws IOException {
        NotebookRepoWithVersionControl.Revision revision = super.checkpoint(noteId, notePath, commitMessage, subject);
        this.updateRemoteStream();
        return revision;
    }

    private void configureRemoteStream() {
        try {
            LOG.debug("Setting up remote stream");
            RemoteAddCommand remoteAddCommand = this.git.remoteAdd();
            remoteAddCommand.setName(this.zeppelinConfiguration.getZeppelinNotebookGitRemoteOrigin());
            remoteAddCommand.setUri(new URIish(this.zeppelinConfiguration.getZeppelinNotebookGitURL()));
            remoteAddCommand.call();
        }
        catch (GitAPIException e) {
            LOG.error("Error configuring GitHub", (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOG.error("Error in GitHub URL provided", (Throwable)e);
        }
    }

    private void updateRemoteStream() {
        LOG.debug("Updating remote stream");
        this.pullFromRemoteStream();
        this.pushToRemoteSteam();
    }

    private void pullFromRemoteStream() {
        try {
            LOG.debug("Pulling latest changes from remote stream");
            PullCommand pullCommand = this.git.pull();
            pullCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.zeppelinConfiguration.getZeppelinNotebookGitUsername(), this.zeppelinConfiguration.getZeppelinNotebookGitAccessToken()));
            pullCommand.call();
        }
        catch (GitAPIException e) {
            LOG.error("Error when pulling latest changes from remote repository", (Throwable)e);
        }
    }

    private void pushToRemoteSteam() {
        try {
            LOG.debug("Pushing latest changes to remote stream");
            PushCommand pushCommand = this.git.push();
            pushCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.zeppelinConfiguration.getZeppelinNotebookGitUsername(), this.zeppelinConfiguration.getZeppelinNotebookGitAccessToken()));
            pushCommand.call();
        }
        catch (GitAPIException e) {
            LOG.error("Error when pushing latest changes to remote repository", (Throwable)e);
        }
    }
}

